/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;

public class XMetaClass
implements Serializable,
Cloneable,
IRNode {
    private int count_;
    private String javaClass_;
    private IRNode parentRNode_;

    public XMetaClass() {
        this.javaClass_ = "";
    }

    public XMetaClass(XMetaClass source) {
        this.setup(source);
    }

    public XMetaClass(RStack stack) {
        this.setup(stack);
    }

    public XMetaClass(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XMetaClass(Element element) {
        this.setup(element);
    }

    public XMetaClass(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XMetaClass(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XMetaClass(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XMetaClass(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XMetaClass(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XMetaClass(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XMetaClass source) {
        this.setCount(source.getCount());
        this.setJavaClass(source.getJavaClass());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        TrierCoreFactory.getFactory();
        new RStack(element);
        this.count_ = URelaxer.getAttributePropertyAsInt(element, "count");
        this.javaClass_ = URelaxer.getAttributePropertyAsString(element, "JavaClass");
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXMetaClass(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("MetaClass");
        URelaxer.setAttributePropertyByInt(element, "count", this.count_);
        URelaxer.setAttributePropertyByString(element, "JavaClass", this.javaClass_);
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final int getCount() {
        return this.count_;
    }

    public final void setCount(int count) {
        this.count_ = count;
    }

    public final String getJavaClass() {
        return this.javaClass_;
    }

    public final void setJavaClass(String javaClass) {
        this.javaClass_ = javaClass;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<MetaClass");
        buffer.append(" count=\"");
        buffer.append(URelaxer.getString(this.getCount()));
        buffer.append("\"");
        if (this.javaClass_ != null) {
            buffer.append(" JavaClass=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJavaClass())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</MetaClass>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<MetaClass");
        buffer.write(" count=\"");
        buffer.write(URelaxer.getString(this.getCount()));
        buffer.write("\"");
        if (this.javaClass_ != null) {
            buffer.write(" JavaClass=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJavaClass())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</MetaClass>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<MetaClass");
        buffer.print(" count=\"");
        buffer.print(URelaxer.getString(this.getCount()));
        buffer.print("\"");
        if (this.javaClass_ != null) {
            buffer.print(" JavaClass=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getJavaClass())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</MetaClass>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getCountAsString() {
        return URelaxer.getString(this.getCount());
    }

    public String getJavaClassAsString() {
        return URelaxer.getString(this.getJavaClass());
    }

    public void setCountByString(String string) {
        this.setCount(Integer.parseInt(string));
    }

    public void setJavaClassByString(String string) {
        this.setJavaClass(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "MetaClass")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "count")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "JavaClass")) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XMetaClass.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XMetaClass.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

