/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.serialize.xml.IXTypedElement;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;

public class XParameter
implements Serializable,
Cloneable,
IXTypedElement,
IRNode {
    private String id_;
    private String name_;
    private String typedStereoType_;
    private String type_;
    private IRNode parentRNode_;

    public XParameter() {
        this.id_ = "";
    }

    public XParameter(XParameter source) {
        this.setup(source);
    }

    public XParameter(RStack stack) {
        this.setup(stack);
    }

    public XParameter(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XParameter(Element element) {
        this.setup(element);
    }

    public XParameter(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XParameter(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XParameter(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XParameter(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XParameter(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XParameter(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XParameter source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setTypedStereoType(source.getTypedStereoType());
        this.setType(source.getType());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        TrierCoreFactory.getFactory();
        new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.typedStereoType_ = URelaxer.getAttributePropertyAsString(element, "typedStereoType");
        this.type_ = URelaxer.getAttributePropertyAsString(element, "type");
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXParameter(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("Parameter");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.typedStereoType_ != null) {
            URelaxer.setAttributePropertyByString(element, "typedStereoType", this.typedStereoType_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getTypedStereoType() {
        return this.typedStereoType_;
    }

    public final void setTypedStereoType(String typedStereoType) {
        this.typedStereoType_ = typedStereoType;
    }

    public final String getType() {
        return this.type_;
    }

    public final void setType(String type) {
        this.type_ = type;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<Parameter");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.append(" typedStereoType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.append("\"");
        }
        if (this.type_ != null) {
            buffer.append(" type=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.append("\"");
        }
        buffer.append(">");
        buffer.append("</Parameter>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<Parameter");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.write(" typedStereoType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.write("\"");
        }
        if (this.type_ != null) {
            buffer.write(" type=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.write("\"");
        }
        buffer.write(">");
        buffer.write("</Parameter>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<Parameter");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.print(" typedStereoType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.print("\"");
        }
        if (this.type_ != null) {
            buffer.print(" type=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getType())));
            buffer.print("\"");
        }
        buffer.print(">");
        buffer.print("</Parameter>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypedStereoTypeAsString() {
        return URelaxer.getString(this.getTypedStereoType());
    }

    public String getTypeAsString() {
        return URelaxer.getString(this.getType());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypedStereoTypeByString(String string) {
        this.setTypedStereoType(string);
    }

    public void setTypeByString(String string) {
        this.setType(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList classNodes = new ArrayList();
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "Parameter")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XParameter.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XParameter.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

