/*
 * Decompiled with CFR 0.152.
 */
package trier.model.core.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import trier.model.core.serialize.xml.IXModelElement;
import trier.model.core.xml.IRNode;
import trier.model.core.xml.ITrierCoreFactory;
import trier.model.core.xml.RStack;
import trier.model.core.xml.TrierCoreFactory;
import trier.model.core.xml.UJAXP;
import trier.model.core.xml.URelaxer;
import trier.model.core.xml.XGuardCondition;
import trier.model.core.xml.XTransitionLabel;

public class XTransition
implements Serializable,
Cloneable,
IXModelElement,
IRNode {
    private String id_;
    private String name_;
    private String typedStereoType_;
    private String sourceState_;
    private String targetState_;
    private XTransitionLabel transitionLabel_;
    private XGuardCondition guardCondition_;
    private IRNode parentRNode_;

    public XTransition() {
        this.id_ = "";
        this.sourceState_ = "";
        this.targetState_ = "";
    }

    public XTransition(XTransition source) {
        this.setup(source);
    }

    public XTransition(RStack stack) {
        this.setup(stack);
    }

    public XTransition(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public XTransition(Element element) {
        this.setup(element);
    }

    public XTransition(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public XTransition(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public XTransition(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public XTransition(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public XTransition(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public XTransition(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(XTransition source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setTypedStereoType(source.getTypedStereoType());
        this.setSourceState(source.getSourceState());
        this.setTargetState(source.getTargetState());
        this.setTransitionLabel(source.getTransitionLabel());
        this.setGuardCondition(source.getGuardCondition());
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        RStack stack = new RStack(element);
        this.id_ = URelaxer.getAttributePropertyAsString(element, "id");
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        this.typedStereoType_ = URelaxer.getAttributePropertyAsString(element, "typedStereoType");
        this.sourceState_ = URelaxer.getAttributePropertyAsString(element, "SourceState");
        this.targetState_ = URelaxer.getAttributePropertyAsString(element, "TargetState");
        if (XTransitionLabel.isMatch(stack)) {
            this.setTransitionLabel(factory.createXTransitionLabel(stack));
        }
        if (XGuardCondition.isMatch(stack)) {
            this.setGuardCondition(factory.createXGuardCondition(stack));
        }
    }

    public Object clone() {
        ITrierCoreFactory factory = TrierCoreFactory.getFactory();
        return factory.createXTransition(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("Transition");
        URelaxer.setAttributePropertyByString(element, "id", this.id_);
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.typedStereoType_ != null) {
            URelaxer.setAttributePropertyByString(element, "typedStereoType", this.typedStereoType_);
        }
        URelaxer.setAttributePropertyByString(element, "SourceState", this.sourceState_);
        URelaxer.setAttributePropertyByString(element, "TargetState", this.targetState_);
        if (this.transitionLabel_ != null) {
            this.transitionLabel_.makeElement(element);
        }
        if (this.guardCondition_ != null) {
            this.guardCondition_.makeElement(element);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public final String getId() {
        return this.id_;
    }

    public final void setId(String id) {
        this.id_ = id;
    }

    public final String getName() {
        return this.name_;
    }

    public final void setName(String name) {
        this.name_ = name;
    }

    public final String getTypedStereoType() {
        return this.typedStereoType_;
    }

    public final void setTypedStereoType(String typedStereoType) {
        this.typedStereoType_ = typedStereoType;
    }

    public final String getSourceState() {
        return this.sourceState_;
    }

    public final void setSourceState(String sourceState) {
        this.sourceState_ = sourceState;
    }

    public final String getTargetState() {
        return this.targetState_;
    }

    public final void setTargetState(String targetState) {
        this.targetState_ = targetState;
    }

    public final XTransitionLabel getTransitionLabel() {
        return this.transitionLabel_;
    }

    public final void setTransitionLabel(XTransitionLabel transitionLabel) {
        this.transitionLabel_ = transitionLabel;
        if (transitionLabel != null) {
            transitionLabel.rSetParentRNode(this);
        }
    }

    public final XGuardCondition getGuardCondition() {
        return this.guardCondition_;
    }

    public final void setGuardCondition(XGuardCondition guardCondition) {
        this.guardCondition_ = guardCondition;
        if (guardCondition != null) {
            guardCondition.rSetParentRNode(this);
        }
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<Transition");
        if (this.id_ != null) {
            buffer.append(" id=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.append("\"");
        }
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.append(" typedStereoType=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.append("\"");
        }
        if (this.sourceState_ != null) {
            buffer.append(" SourceState=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceState())));
            buffer.append("\"");
        }
        if (this.targetState_ != null) {
            buffer.append(" TargetState=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetState())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.transitionLabel_ != null) {
            this.transitionLabel_.makeTextElement(buffer);
        }
        if (this.guardCondition_ != null) {
            this.guardCondition_.makeTextElement(buffer);
        }
        buffer.append("</Transition>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<Transition");
        if (this.id_ != null) {
            buffer.write(" id=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.write("\"");
        }
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.write(" typedStereoType=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.write("\"");
        }
        if (this.sourceState_ != null) {
            buffer.write(" SourceState=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceState())));
            buffer.write("\"");
        }
        if (this.targetState_ != null) {
            buffer.write(" TargetState=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetState())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.transitionLabel_ != null) {
            this.transitionLabel_.makeTextElement(buffer);
        }
        if (this.guardCondition_ != null) {
            this.guardCondition_.makeTextElement(buffer);
        }
        buffer.write("</Transition>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<Transition");
        if (this.id_ != null) {
            buffer.print(" id=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getId())));
            buffer.print("\"");
        }
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        if (this.typedStereoType_ != null) {
            buffer.print(" typedStereoType=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTypedStereoType())));
            buffer.print("\"");
        }
        if (this.sourceState_ != null) {
            buffer.print(" SourceState=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSourceState())));
            buffer.print("\"");
        }
        if (this.targetState_ != null) {
            buffer.print(" TargetState=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getTargetState())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.transitionLabel_ != null) {
            this.transitionLabel_.makeTextElement(buffer);
        }
        if (this.guardCondition_ != null) {
            this.guardCondition_.makeTextElement(buffer);
        }
        buffer.print("</Transition>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getIdAsString() {
        return URelaxer.getString(this.getId());
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getTypedStereoTypeAsString() {
        return URelaxer.getString(this.getTypedStereoType());
    }

    public String getSourceStateAsString() {
        return URelaxer.getString(this.getSourceState());
    }

    public String getTargetStateAsString() {
        return URelaxer.getString(this.getTargetState());
    }

    public void setIdByString(String string) {
        this.setId(string);
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setTypedStereoTypeByString(String string) {
        this.setTypedStereoType(string);
    }

    public void setSourceStateByString(String string) {
        this.setSourceState(string);
    }

    public void setTargetStateByString(String string) {
        this.setTargetState(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList<IXModelElement> classNodes = new ArrayList<IXModelElement>();
        if (this.transitionLabel_ != null) {
            classNodes.add(this.transitionLabel_);
        }
        if (this.guardCondition_ != null) {
            classNodes.add(this.guardCondition_);
        }
        IRNode[] nodes = new IRNode[classNodes.size()];
        return classNodes.toArray(nodes);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "Transition")) {
            return false;
        }
        RStack target = new RStack(element);
        if (!URelaxer.hasAttributeHungry(target, "id")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "SourceState")) {
            return false;
        }
        if (!URelaxer.hasAttributeHungry(target, "TargetState")) {
            return false;
        }
        XTransitionLabel.isMatchHungry(target);
        XGuardCondition.isMatchHungry(target);
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return XTransition.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (XTransition.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

