/*
 * Decompiled with CFR 0.152.
 */
package trier.model.object;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import trier.model.command.TCommand;
import trier.model.core.TMetaClass;
import trier.model.core.TModelElement;
import trier.model.object.TInstance;
import trier.model.object.TValue;

public class TInstanceVariable
extends TModelElement {
    private TValue value = null;
    private TInstance $owner;
    private boolean array = false;
    private List arrayVariables = new ArrayList();

    public TInstanceVariable(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void remove() {
        super.remove();
        if (this.$owner != null && this.$owner.getVariables().contains(this)) {
            this.$owner.removeVariable(this);
        }
        if (!this.value.isNull()) {
            this.removeElements(Collections.singletonList(this.value));
        }
        this.removeElements(this.arrayVariables);
    }

    protected void comeBack() {
        super.comeBack();
        if (this.$owner != null && !this.$owner.getVariables().contains(this)) {
            this.$owner.addVariable(this);
        }
        if (!this.value.isNull()) {
            this.comeBackElements(Collections.singletonList(this.value));
            this.comeBackElements(this.arrayVariables);
        }
    }

    public String getElementType() {
        return "InstanceVariable";
    }

    public String getTagName() {
        return "InstanceVariable";
    }

    public TValue getValue() {
        return this.value;
    }

    protected void setValue(TValue value) {
        this.value = value;
        this.fireStructureChange("TModelElement changed");
    }

    public List getArrayVariables() {
        return new ArrayList(this.arrayVariables);
    }

    public TInstance getOwner() {
        return this.$owner;
    }

    public void setOwner(TInstance instance) {
        this.$owner = instance;
    }

    public List getModelChildren() {
        List children = super.getModelChildren();
        if (!this.value.isNull()) {
            children.add(this.value);
            children.addAll(this.value.getModelChildren());
        }
        Iterator i = this.arrayVariables.iterator();
        while (i.hasNext()) {
            TModelElement element = (TModelElement)i.next();
            if (element.isNull()) continue;
            children.add(element);
            children.addAll(element.getModelChildren());
        }
        return children;
    }

    public boolean isArray() {
        return this.array;
    }

    protected void deleteArray() {
        if (this.array) {
            this.removeElements(this.arrayVariables);
            this.array = false;
            this.fireStructureChange("TModelElement changed");
        }
    }

    protected void comeBackArray() {
        if (this.arrayVariables.size() > 0) {
            this.comeBackElements(this.arrayVariables);
            this.array = true;
            this.fireStructureChange("TModelElement changed");
        }
    }

    protected void toArray(int size) {
        this.setSize(size);
        this.array = true;
        this.fireStructureChange("TModelElement changed");
    }

    protected void setSize(int size) {
        new ArrayList();
        int preSize = this.arrayVariables.size();
        if (preSize > size) {
            List newVariables = this.arrayVariables.subList(0, size);
            List removedVariables = this.arrayVariables.subList(size, preSize);
            this.removeElements(removedVariables);
            this.arrayVariables = new ArrayList(newVariables);
        } else if (preSize < size) {
            int i = preSize;
            while (i < size) {
                this.addArrayElement();
                ++i;
            }
        }
        this.fireStructureChange("TModelElement changed");
    }

    private void addArrayElement() {
        TMetaClass variableMetaClass = this.getMetaClass();
        TMetaClass valueMetaClass = this.value.getMetaClass();
        TInstanceVariable variable = (TInstanceVariable)variableMetaClass.createInstance();
        TValue value = (TValue)valueMetaClass.createInstance();
        variable.getMetaClass().addInstance(variable);
        value.getMetaClass().addInstance(value);
        variable.setValue(value);
        int index = this.arrayVariables.size();
        variable.setName("[" + index + "]");
        this.arrayVariables.add(variable);
    }

    public TCommand toArrayCommand(final int size) {
        return new TCommand(){
            private boolean oldState;
            private int oldSize;
            private int newSize;

            public void execute() {
                this.oldState = TInstanceVariable.this.isArray();
                this.newSize = size;
                this.oldSize = TInstanceVariable.this.arrayVariables.size();
                TInstanceVariable.this.toArray(size);
            }

            public void undo() {
                if (this.oldState) {
                    TInstanceVariable.this.toArray(this.oldSize);
                } else {
                    TInstanceVariable.this.deleteArray();
                }
            }

            public void redo() {
                if (this.oldState) {
                    TInstanceVariable.this.toArray(this.newSize);
                } else {
                    TInstanceVariable.this.comeBackArray();
                }
            }
        };
    }

    public TCommand deleteArrayCommand() {
        return new TCommand(){

            public void execute() {
                TInstanceVariable.this.deleteArray();
            }

            public void undo() {
                TInstanceVariable.this.comeBackArray();
            }
        };
    }
}

