/*
 * Decompiled with CFR 0.152.
 */
package trier.model.sequence;

import java.util.List;
import trier.model.core.TMetaClass;
import trier.model.core.TModelElement;
import trier.model.sequence.TMessageLabel;
import trier.model.sequence.TSequenciableElement;

public class TMessage
extends TModelElement {
    private TSequenciableElement $source;
    private TSequenciableElement $target;
    private TMessageLabel messageLabel;

    protected TMessage(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void remove() {
        super.remove();
        if (!this.isNull()) {
            if (this.$source.getSequences().contains(this)) {
                this.$source.removeSequence(this);
            }
            if (this.$target.getSequences().contains(this)) {
                this.$target.removeSequence(this);
            }
            if (!this.messageLabel.isNull() && !this.messageLabel.isRemoved()) {
                this.messageLabel.remove();
            }
        }
    }

    protected void comeBack() {
        super.comeBack();
        if (!this.isNull()) {
            if (!this.$source.getSequences().contains(this)) {
                this.$source.addSequence(this);
            }
            if (!this.$target.getSequences().contains(this)) {
                this.$target.addSequence(this);
            }
            if (!this.messageLabel.isNull() && this.messageLabel.isRemoved()) {
                this.messageLabel.comeBack();
            }
        }
    }

    public List getModelChildren() {
        List children = super.getModelChildren();
        if (!this.messageLabel.isNull()) {
            children.add(this.messageLabel);
            children.addAll(this.messageLabel.getModelChildren());
        }
        return children;
    }

    public TSequenciableElement getSource() {
        return this.$source;
    }

    public TSequenciableElement getTarget() {
        return this.$target;
    }

    protected void setSource(TSequenciableElement element) {
        this.$source = element;
        this.fireStructureChange("TModelElement changed");
    }

    protected void setTarget(TSequenciableElement element) {
        this.$target = element;
        this.fireStructureChange("TModelElement changed");
    }

    public TMessageLabel getMessageLabel() {
        return this.messageLabel;
    }

    protected void setMessageLabel(TMessageLabel message) {
        this.messageLabel = message;
    }

    public String getElementType() {
        return "Message";
    }

    public String getTagName() {
        return "Message";
    }
}

