/*
 * Decompiled with CFR 0.152.
 */
package trier.model.state;

import java.util.Iterator;
import java.util.List;
import trier.model.core.TMetaClass;
import trier.model.state.TFinalState;
import trier.model.state.TInitialState;
import trier.model.state.TState;
import trier.model.state.TStateMachine;
import trier.model.state.TStateMachineImpl;
import trier.model.state.TTransition;

public final class TCompositeState
extends TState
implements TStateMachine {
    protected TStateMachineImpl impl = new TStateMachineImpl();

    protected TCompositeState(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    public List getAllStates() {
        return this.impl.getAllStates();
    }

    protected void comeBack() {
        super.comeBack();
        super.getParent().addState(this);
        Iterator i = this.getAllStates().iterator();
        while (i.hasNext()) {
            TState tState = (TState)i.next();
            tState.comeBack();
        }
    }

    protected void remove() {
        super.remove();
        super.getParent().removeState(this);
        Iterator i = this.getAllStates().iterator();
        while (i.hasNext()) {
            TState tState = (TState)i.next();
            tState.remove();
        }
    }

    public List getStates() {
        return this.impl.getStates();
    }

    public void addState(TState state) {
        this.impl.addState(state);
        super.fireStructureChange("TModelElement changed");
    }

    public void removeState(TState targetState) {
        this.impl.removeState(targetState);
        super.fireStructureChange("TModelElement changed");
    }

    public TInitialState getInitialState() {
        return this.impl.getInitialState();
    }

    public void setInitialState(TInitialState newInitState) {
        this.impl.setInitialState(newInitState);
        super.fireStructureChange("TModelElement changed");
    }

    public List getFinalStates() {
        return this.impl.getFinalStates();
    }

    public void addFinalState(TFinalState finalState) {
        this.impl.addFinalState(finalState);
        super.fireStructureChange("TModelElement changed");
    }

    public void removeFinalState(TFinalState targetFinalState) {
        this.impl.removeFinalState(targetFinalState);
        super.fireStructureChange("TModelElement changed");
    }

    public void addTransition(TTransition transition) {
        this.impl.addTransition(transition);
    }

    public List getAllTransitions() {
        return this.impl.getAllTransitions();
    }

    public void removeTransition(TTransition transition) {
        this.impl.removeTransition(transition);
    }

    protected void setName(String name) {
        super.setName(name);
    }

    public String getElementType() {
        return "State";
    }

    public String getTagName() {
        return "State";
    }
}

