/*
 * Decompiled with CFR 0.152.
 */
package trier.model.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import trier.model.core.TMetaClass;
import trier.model.core.TModelElement;
import trier.model.state.TStateMachine;
import trier.model.state.TTransition;

public abstract class TState
extends TModelElement {
    private static final Logger logger;
    private List $sourceTransitions = new ArrayList();
    private List $targetTransitions = new ArrayList();
    private TStateMachine $parent;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("trier.model.state.TState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("trier.model.state.TState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    protected TState(TMetaClass metaClass, String id) {
        super(metaClass, id);
    }

    protected void comeBack() {
        TTransition tTransition;
        super.comeBack();
        Iterator i = this.$sourceTransitions.iterator();
        while (i.hasNext()) {
            tTransition = (TTransition)i.next();
            if (tTransition.getSourceState() != this) continue;
            tTransition.comeBack();
        }
        i = this.$targetTransitions.iterator();
        while (i.hasNext()) {
            tTransition = (TTransition)i.next();
            if (tTransition.getTargetState() != this) continue;
            tTransition.comeBack();
        }
    }

    protected void remove() {
        TTransition tTransition;
        super.remove();
        Iterator i = this.$sourceTransitions.iterator();
        while (i.hasNext()) {
            tTransition = (TTransition)i.next();
            if (tTransition.getSourceState() != this) continue;
            tTransition.remove();
        }
        i = this.$targetTransitions.iterator();
        while (i.hasNext()) {
            tTransition = (TTransition)i.next();
            if (tTransition.getTargetState() != this) continue;
            tTransition.remove();
        }
    }

    public List getSourceTransitions() {
        return new ArrayList(this.$sourceTransitions);
    }

    protected void addSourceTransition(TTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Added source transition is null!");
        }
        if (!$assertionsDisabled && this.$sourceTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.$sourceTransitions.add(transition);
        super.fireStructureChange("TModelElement changed");
    }

    protected void removeSourceTransition(TTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Removed source transition is null!");
        }
        if (!$assertionsDisabled && !this.$sourceTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.$sourceTransitions.remove(transition);
        super.fireStructureChange("TModelElement changed");
    }

    public List getTargetTransitions() {
        return new ArrayList(this.$targetTransitions);
    }

    protected void addTargetTransition(TTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Added TargetTransition is null!");
        }
        if (!$assertionsDisabled && this.$targetTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.$targetTransitions.add(transition);
        super.fireStructureChange("TModelElement changed");
    }

    protected void removeTargetTransition(TTransition transition) {
        if (!$assertionsDisabled && transition == null) {
            throw new AssertionError((Object)"Removed target transition is null!");
        }
        if (!$assertionsDisabled && !this.$targetTransitions.contains(transition)) {
            throw new AssertionError();
        }
        logger.debug((Object)transition);
        this.$targetTransitions.remove(transition);
        super.fireStructureChange("TModelElement changed");
    }

    public TStateMachine getParent() {
        return this.$parent;
    }

    protected void setParent(TStateMachine machine) {
        this.$parent = machine;
    }
}

