/*
 * Decompiled with CFR 0.152.
 */
package trier.objectdiagram.edit.property;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.model.EElement;
import trier.model.object.TInstanceVariable;

public class ODInstanceVariableEditDialog
extends EEditDialog
implements ModifyListener {
    private Button arrayButton;
    private Text sizeText;

    public ODInstanceVariableEditDialog(EEditDialog parentDialog, EElement element) {
        super(parentDialog, element);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("InstanceVariable Specification");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        this.initializeArrayCheckComposite(composite);
        this.initializeSizeComposite(composite);
        composite.pack();
        this.updateIsArray();
        this.updateArraySize();
        return composite;
    }

    private void initializeArrayCheckComposite(Composite composite) {
        Composite arrayCheckComposite = new Composite(composite, 0);
        arrayCheckComposite.setLayout((Layout)new RowLayout(256));
        this.arrayButton = new Button(arrayCheckComposite, 32);
        if (this.getTInstanceVariable().isArray()) {
            this.arrayButton.setSelection(true);
        }
        this.arrayButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ODInstanceVariableEditDialog.this.arrayButtonSeletcted(e);
            }
        });
        Label label = new Label(arrayCheckComposite, 0);
        label.setText("Array Variable");
    }

    private void initializeSizeComposite(Composite composite) {
        Composite sizeComposite = new Composite(composite, 0);
        sizeComposite.setLayout((Layout)new RowLayout(256));
        Label label = new Label(sizeComposite, 0);
        label.setText("size:");
        this.sizeText = new Text(sizeComposite, 2048);
        this.sizeText.setLayoutData((Object)new RowData(40, 12));
    }

    private int getSize() {
        try {
            int size = Integer.parseInt(this.sizeText.getText());
            size = Math.min(size, 10);
            size = Math.max(size, 1);
            return size;
        }
        catch (Exception exception) {
            return 1;
        }
    }

    private void arrayButtonSeletcted(SelectionEvent e) {
        boolean isArray = this.arrayButton.getSelection();
        if (isArray) {
            super.executeCommand(this.getTInstanceVariable().toArrayCommand(this.getSize()));
        } else if (this.getTInstanceVariable().isArray()) {
            super.executeCommand(this.getTInstanceVariable().deleteArrayCommand());
        }
        this.updateIsArray();
    }

    public void modifyText(ModifyEvent e) {
        super.executeCommand(this.getTInstanceVariable().toArrayCommand(this.getSize()));
        this.updateArraySize();
    }

    private void updateArraySize() {
        this.sizeText.removeModifyListener((ModifyListener)this);
        int size = this.getTInstanceVariable().getArrayVariables().size();
        this.sizeText.setText(Integer.toString(size));
        this.sizeText.addModifyListener((ModifyListener)this);
    }

    private void updateIsArray() {
        boolean isArray = this.getTInstanceVariable().isArray();
        if (isArray) {
            this.sizeText.setEnabled(true);
        } else {
            this.sizeText.setEnabled(false);
        }
    }

    private TInstanceVariable getTInstanceVariable() {
        return (TInstanceVariable)this.getTModel();
    }
}

