/*
 * Decompiled with CFR 0.152.
 */
package trier.objectdiagram.edit.property;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import trier.classdiagram.edit.property.CDModelElementTableEditor;
import trier.classdiagram.edit.property.CDModelElementTableEditorComposite;
import trier.model.core.TElement;
import trier.model.object.TInstance;
import trier.model.object.TInstanceVariable;
import trier.objectdiagram.edit.property.ODVariableTableEditComposite;

public class ODVariableTableEditor
extends CDModelElementTableEditor {
    public ODVariableTableEditor(CDModelElementTableEditorComposite composite, TElement element) {
        super(composite, element);
    }

    private TInstance getInstance() {
        return (TInstance)this.getTElement();
    }

    private ODVariableTableEditComposite getVariableEditComposite() {
        return (ODVariableTableEditComposite)this.getTableEditorComposite();
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Value"};
    }

    protected int[] getColumnWidth() {
        return new int[]{150, 150};
    }

    protected Object getElements() {
        return this.getInstance().getVariables();
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)};
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new VariableModifier();
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new VariableLabelProvider();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElements) {
                return ODVariableTableEditor.this.getInstance().getVariables().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object obj, Object newObj) {
            }
        };
    }

    class VariableModifier
    implements ICellModifier {
        VariableModifier() {
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            TInstanceVariable attribute = (TInstanceVariable)element;
            if (property.equals(ODVariableTableEditor.this.getColumnNames()[0])) {
                return attribute.getName();
            }
            if (property.equals(ODVariableTableEditor.this.getColumnNames()[1])) {
                return attribute.getValue().getName();
            }
            return null;
        }

        private int getSelectionIndex(String key, String[] from) {
            int i = 0;
            while (i < from.length) {
                if (from[i].equals(key)) {
                    return i;
                }
                ++i;
            }
            return 0;
        }

        public void modify(Object element, String property, Object value) {
            TInstanceVariable attribute = (TInstanceVariable)((TableItem)element).getData();
            if (property.equals(ODVariableTableEditor.this.getColumnNames()[0])) {
                String valueStr = (String)value;
                ODVariableTableEditor.this.getVariableEditComposite().modifyElementName(attribute, valueStr);
            } else if (property.equals(ODVariableTableEditor.this.getColumnNames()[1])) {
                String valueStr = (String)value;
                ODVariableTableEditor.this.getVariableEditComposite().modifyElementValue(attribute, valueStr);
            } else {
                property.equals(ODVariableTableEditor.this.getColumnNames()[2]);
            }
            ODVariableTableEditor.this.getTableViewer().update((Object)attribute, null);
        }
    }

    class VariableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VariableLabelProvider() {
        }

        public String getColumnText(Object element, int index) {
            TInstanceVariable attribute = (TInstanceVariable)element;
            switch (index) {
                case 0: {
                    return attribute.getName();
                }
                case 1: {
                    return attribute.getValue().getName();
                }
            }
            return null;
        }

        public Image getColumnImage(Object elemnt, int index) {
            return null;
        }
    }
}

