/*
 * Decompiled with CFR 0.152.
 */
package trier.objectdiagram.model;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.model.EElement;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TModelElement;
import trier.model.core.TPackage;
import trier.model.object.TInstance;
import trier.model.object.TLink;
import trier.model.object.TObjectModel;

public class ODDocument
extends CDDocument {
    public static final String LINK = "Link";
    public static final String LINK_NAVIGABLE = "LinkNavigable";
    public static final String OBJECT_MODEL = "ObjectModel";
    public static final String INSTANCE = "Instance";
    public static final String OBJECT_VARIABLE = "InstanceVariable";
    public static final String DEFAULT_OBJECT_NAME = ": NewInstance";
    private TObjectModel objectModel;

    public ODDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
    }

    public EElement createNodeElement(String nodeType) {
        if (nodeType.equals(INSTANCE)) {
            return this.createInstance(DEFAULT_OBJECT_NAME);
        }
        return super.createNodeElement(nodeType);
    }

    public EElement createConnectionEElement(String connectionType, DNode source, DNode target) {
        if (connectionType.equals(LINK)) {
            return this.createLink(source, target);
        }
        if (connectionType.equals(LINK_NAVIGABLE)) {
            return this.createNavigableLink(source, target);
        }
        return super.createConnectionEElement(connectionType, source, target);
    }

    protected EElement createLink(DNode source, DNode target) {
        TLink model = this.getTDocument().createLink();
        DConnection connection = this.getDDocument().createConnection(model.getId(), source, target);
        return new EElement(model, (DElement)connection);
    }

    protected EElement createNavigableLink(DNode source, DNode target) {
        TLink model = this.getTDocument().createNavigableLink();
        DConnection connection = this.getDDocument().createConnection(model.getId(), source, target);
        return new EElement(model, (DElement)connection);
    }

    protected EElement createInstance(String name) {
        TInstance tElement = this.getTDocument().createInstance(name);
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    public void prepareObjectModel() {
        TPackage namespace = this.getPackage();
        String id = this.getDDocument().getId();
        TModelElement diagramModel = this.getTDocument().getTElement(id);
        if (diagramModel != null && diagramModel instanceof TObjectModel) {
            this.objectModel = (TObjectModel)diagramModel;
        } else {
            this.objectModel = this.getTDocument().createObjectModel();
            this.getTDocument().addOwnedElement(namespace, this.objectModel);
            this.getDDocument().setId(this.objectModel.getId());
        }
    }

    public TElement getDiagramOwner() {
        return this.objectModel;
    }

    protected TDocument createInitialTDocument() {
        return new TDocument();
    }
}

