/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.edit.property;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DLabel;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import trier.diagrameditor.edit.property.EEditDialog;
import trier.diagrameditor.model.ECommand;
import trier.diagrameditor.model.EEditDomain;
import trier.diagrameditor.model.EElement;
import trier.model.sequence.TMessage;
import trier.model.sequence.TMessageLabel;
import trier.sequencediagram.QDConstants;

public class QDMessageEditDialog
extends EEditDialog {
    private Text messageText;

    public QDMessageEditDialog(EEditDomain domain, EElement element) {
        super(domain, element);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Message Specification");
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.initializeMessageComposite(composite);
        composite.pack();
        return composite;
    }

    protected void initializeMessageComposite(Composite composite) {
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText("Message:");
        this.messageText = new Text(composite, 2048);
        if (!this.getTMessageLabel().isNull()) {
            this.messageText.setText(this.getTMessageLabel().getName());
        }
        this.messageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                QDMessageEditDialog.this.messageChanged(e);
            }
        });
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        this.messageText.setLayoutData((Object)gridData);
    }

    protected void messageChanged(ModifyEvent e) {
        if (this.messageText.getText().length() == 0) {
            CompoundCommand removeCommand = new CompoundCommand();
            removeCommand.add(super.getEEditDomain().createRemoveEElementCommand(this.getEMessage()));
            removeCommand.add((Command)new ECommand(super.getTCommandFactory().createRemoveTElementCommand(this.getTMessageLabel())));
            super.executeCommand((Command)removeCommand);
        } else {
            CompoundCommand setMessageCommand = new CompoundCommand();
            if (this.getEMessage() == null) {
                setMessageCommand.add((Command)this.createCreateMessageCommand(this.messageText.getText()));
            } else {
                setMessageCommand.add((Command)new ECommand(this.getTCommandFactory().createSetNameCommand(this.getTMessageLabel(), this.messageText.getText())));
            }
            super.executeCommand((Command)setMessageCommand);
        }
    }

    protected CompoundCommand createCreateMessageCommand(String name) {
        CompoundCommand createMessageCommand = new CompoundCommand();
        TMessageLabel message = this.getTDocument().createMessageLabel(name);
        createMessageCommand.add((Command)new ECommand(this.getTCommandFactory().createSetMessageLabelCommand(this.getTMessage(), message)));
        DLabel label = super.getDDocument().createLabel(message.getId(), (DConnection)this.getEModel().getDModel());
        createMessageCommand.add(super.getDCommandFactory().createSetLocationCommand(label, QDConstants.LABEL_RELATIVE_POINT));
        EElement element = new EElement(message, (DElement)label);
        createMessageCommand.add(this.getEEditDomain().createAddEElementCommand(element));
        return createMessageCommand;
    }

    protected TMessage getTMessage() {
        return (TMessage)this.getTModel();
    }

    protected TMessageLabel getTMessageLabel() {
        return this.getTMessage().getMessageLabel();
    }

    protected EElement getEMessage() {
        List eElements = super.getEDocument().getElementsByTElement(this.getTMessageLabel());
        if (eElements.isEmpty()) {
            return null;
        }
        return (EElement)eElements.get(0);
    }

    public Text getMessageText() {
        return this.messageText;
    }
}

