/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.editpart;

import java.util.ArrayList;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import trier.diagrameditor.editpart.EConnectionEditPart;
import trier.sequencediagram.edit.property.QDMessageEditDialog;
import trier.sequencediagram.editpart.QDSourceConstraint;
import trier.sequencediagram.figure.QDConnectionFigureFactory;
import trier.sequencediagram.figure.QDRelativeBendpoint;
import trier.sequencediagram.figure.QDSequenciableElementFigure;

public class QDMessageEditPart
extends EConnectionEditPart {
    public boolean understandsRequest(Request request) {
        if (request.getType().equals("property edit")) {
            return true;
        }
        return super.understandsRequest(request);
    }

    protected void showDirectEditor() {
        this.showPropertyEditor();
    }

    protected void showPropertyEditor() {
        QDMessageEditDialog dialog = new QDMessageEditDialog(this.getEditDomain(), this.getElement());
        dialog.open();
    }

    protected void refreshVisuals() {
        this.refreshFigure();
        super.refreshVisuals();
    }

    private void refreshFigure() {
        PolylineConnection connection = (PolylineConnection)this.getConnectionFigure();
        QDConnectionFigureFactory.addSequenceDecoration(connection);
    }

    protected void refreshBendpoints() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            return;
        }
        if (this.getSource() != this.getTarget()) {
            this.getDConnectionFigure().setRoutingConstraint(null);
            return;
        }
        ArrayList<QDRelativeBendpoint> constraint = new ArrayList<QDRelativeBendpoint>();
        QDRelativeBendpoint bp1 = new QDRelativeBendpoint(this.getFigure(), this.getSourceConnectionAnchor(), new Dimension(50, 0));
        constraint.add(bp1);
        QDRelativeBendpoint bp2 = new QDRelativeBendpoint(this.getFigure(), this.getSourceConnectionAnchor(), new Dimension(50, 10));
        constraint.add(bp2);
        this.getDConnectionFigure().setRoutingConstraint(constraint);
    }

    protected void initializeBendpointEditPolicy() {
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new MessageBendpointEditPolicy());
    }

    class MessageBendpointEditPolicy
    extends BendpointEditPolicy {
        MessageBendpointEditPolicy() {
        }

        protected Command getCreateBendpointCommand(BendpointRequest request) {
            Point loc = request.getLocation();
            QDSequenciableElementFigure fig = (QDSequenciableElementFigure)((GraphicalEditPart)QDMessageEditPart.this.getSource()).getFigure();
            fig.translateToRelative((Translatable)loc);
            int index = fig.getConnectionAnchorIndex(loc);
            QDSourceConstraint constraint = new QDSourceConstraint(index);
            return QDMessageEditPart.this.getEditDomain().getDCommandFactory().createSetSourceConnectionConstraintCommand(QDMessageEditPart.this.getDConnection(), (Object)constraint);
        }

        protected Command getDeleteBendpointCommand(BendpointRequest request) {
            return null;
        }

        protected Command getMoveBendpointCommand(BendpointRequest request) {
            return null;
        }
    }
}

