/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.figure;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import trier.TrierPlugin;
import trier.diagrameditor.figure.ENodeFigure;
import trier.model.sequence.TSequenciableElement;
import trier.sequencediagram.QDConstants;
import trier.sequencediagram.figure.QDElementFigure;
import trier.sequencediagram.figure.QDLifeLineFigure;
import trier.sequencediagram.figure.anchors.QDSourceAnchor;
import trier.sequencediagram.figure.anchors.QDTargetAnchor;

public abstract class QDSequenciableElementFigure
extends ENodeFigure {
    private Figure parentLayer = new Figure();
    private QDElementFigure objectLayer = null;
    private QDLifeLineFigure lifeLineLayer = new QDLifeLineFigure();
    public static int anchorInterval = 10;
    private ConnectionAnchor targetConnectionAnchor;
    private ConnectionAnchor defaultConnectionAnchor;
    public static final int xMargin = 10;
    public static final int yMargin = 10;
    private int layoutCurrentHeight = 0;

    public QDSequenciableElementFigure() {
        this.initialize();
        this.initializeComponents();
        this.initializeConnectionAnchors();
    }

    protected void initialize() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
    }

    protected void initializeComponents() {
        DelegatingLayout titleLayout = new DelegatingLayout();
        this.parentLayer.setLayoutManager((LayoutManager)titleLayout);
        this.parentLayer.setForegroundColor(QDConstants.DEFAULT_SEQUENCE_PEN_COLOR);
        this.add((IFigure)this.parentLayer);
        this.objectLayer = this.createObjectFigure();
        this.parentLayer.add((IFigure)this.objectLayer, (Object)new ElementLocator());
        this.parentLayer.add((IFigure)this.lifeLineLayer, (Object)new LifeLineLocator());
    }

    protected abstract QDElementFigure createObjectFigure();

    private void initializeConnectionAnchors() {
        this.targetConnectionAnchor = new QDTargetAnchor((IFigure)this.lifeLineLayer);
        this.defaultConnectionAnchor = new ChopboxAnchor((IFigure)this.objectLayer);
    }

    public ConnectionAnchor getConnectionAnchor(int index) {
        return new QDSourceAnchor((IFigure)this.lifeLineLayer, index);
    }

    public ConnectionAnchor getDefaultConnectionAnchor() {
        return this.defaultConnectionAnchor;
    }

    public ConnectionAnchor getConnectionAnchor(Point relative) {
        int index = this.getConnectionAnchorIndex(relative);
        return this.getConnectionAnchor(index);
    }

    public int getConnectionAnchorIndex(Point relative) {
        Point p = new Point(this.lifeLineLayer.getLocation());
        p.x = relative.x - p.x;
        p.y = relative.y - p.y;
        int index = (p.y + anchorInterval / 2) / anchorInterval;
        return index > 0 ? index : 0;
    }

    public ConnectionAnchor getTargetConnectionAnchor() {
        return this.targetConnectionAnchor;
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(TrierPlugin.DEFAULT_CLASS_PEN_COLOR);
        g.setBackgroundColor(TrierPlugin.DEFAULT_CLASS_FILL_COLOR);
        g.setLineWidth(1);
    }

    public Label getTitleLabel() {
        return this.objectLayer.getTitleLabel();
    }

    public void updateVisual(TSequenciableElement sequenciableElement) {
        this.getTitleLabel().setText(sequenciableElement.getName());
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.parentLayer.setBounds(r);
        this.layoutCurrentHeight = 0;
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (index == -1) {
            super.add(figure, constraint, index);
        } else if (figure == this.parentLayer) {
            super.add(figure, constraint, 0);
        } else {
            super.add(figure, constraint, index + 1);
        }
    }

    private int layoutGetWidth() {
        Rectangle r = this.getBounds();
        return r.width;
    }

    private int layoutGetHeight() {
        Rectangle r = this.getBounds();
        return r.height;
    }

    private Point layoutGetLocation() {
        Rectangle r = this.getBounds();
        int x = r.x + 10;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    private Point layoutGetLocationNoMargin() {
        Rectangle r = this.getBounds();
        int x = r.x;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    public void repaint() {
        super.repaint();
    }

    class TitleLabelLocator
    implements Locator {
        TitleLabelLocator() {
        }

        public void relocate(IFigure target) {
            QDSequenciableElementFigure.this.layoutCurrentHeight = 10;
            int width = QDSequenciableElementFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(QDSequenciableElementFigure.this.layoutGetLocation(), new Dimension(width, height)));
            QDSequenciableElementFigure qDSequenciableElementFigure = QDSequenciableElementFigure.this;
            qDSequenciableElementFigure.layoutCurrentHeight = qDSequenciableElementFigure.layoutCurrentHeight + height;
        }
    }

    class ElementLocator
    implements Locator {
        ElementLocator() {
        }

        public void relocate(IFigure target) {
            int width = QDSequenciableElementFigure.this.layoutGetWidth();
            int height = 120;
            target.setBounds(new Rectangle(QDSequenciableElementFigure.this.layoutGetLocationNoMargin(), new Dimension(width, height)));
            QDSequenciableElementFigure qDSequenciableElementFigure = QDSequenciableElementFigure.this;
            qDSequenciableElementFigure.layoutCurrentHeight = qDSequenciableElementFigure.layoutCurrentHeight + height;
        }
    }

    class LifeLineLocator
    implements Locator {
        LifeLineLocator() {
        }

        public void relocate(IFigure target) {
            int width = 10;
            int height = QDSequenciableElementFigure.this.getBounds().height - 120;
            Point parentLocation = QDSequenciableElementFigure.this.layoutGetLocationNoMargin();
            target.setBounds(new Rectangle(parentLocation.x + (QDSequenciableElementFigure.this.layoutGetWidth() - width) / 2, parentLocation.y, width, height));
            QDSequenciableElementFigure qDSequenciableElementFigure = QDSequenciableElementFigure.this;
            qDSequenciableElementFigure.layoutCurrentHeight = qDSequenciableElementFigure.layoutCurrentHeight + height;
        }
    }
}

