/*
 * Decompiled with CFR 0.152.
 */
package trier.sequencediagram.model;

import diagrammodelfw.model.DConnection;
import diagrammodelfw.model.DElement;
import diagrammodelfw.model.DNode;
import trier.classdiagram.model.CDDocument;
import trier.diagrameditor.model.EElement;
import trier.model.core.TDocument;
import trier.model.core.TElement;
import trier.model.core.TModelElement;
import trier.model.core.TPackage;
import trier.model.sequence.TActor;
import trier.model.sequence.TMessage;
import trier.model.sequence.TSequenceModel;
import trier.model.sequence.TSequenciableObject;

public class QDDocument
extends CDDocument {
    public static final String MESSAGE = "Message";
    public static final String SEQUENCIABLE_OBJECT = "SequenciableObject";
    public static final String ACTOR = "Actor";
    public static final String DEFAULT_SEQUENCIABLE_OBJECT_NAME = "NewObject";
    public static final String DEFAULT_ACTOR_NAMEACTOR = "NewActor";
    public static final String RIGHT_SELF_MESSAGE = "Right_Self_Message";
    public static final String LEFT_SELF_MESSAGE = "Left_Self_Message";
    private TSequenceModel sequenceModel;

    public QDDocument(TElement tModel, DElement dModel) {
        super(tModel, dModel);
    }

    public EElement createNodeElement(String nodeType) {
        if (nodeType.equals(SEQUENCIABLE_OBJECT)) {
            return this.createSequenciableObject(DEFAULT_SEQUENCIABLE_OBJECT_NAME);
        }
        if (nodeType.equals(ACTOR)) {
            return this.createActor(DEFAULT_ACTOR_NAMEACTOR);
        }
        return super.createNodeElement(nodeType);
    }

    public EElement createConnectionEElement(String connectionType, DNode source, DNode target) {
        if (connectionType.equals(MESSAGE)) {
            return this.createMessage(source, target);
        }
        if (connectionType.equals(RIGHT_SELF_MESSAGE)) {
            return this.createMessage(source, target);
        }
        if (connectionType.equals(LEFT_SELF_MESSAGE)) {
            return this.createMessage(source, target);
        }
        return super.createConnectionEElement(connectionType, source, target);
    }

    protected EElement createMessage(DNode source, DNode target) {
        TMessage model = this.getTDocument().createMessage();
        DConnection connection = this.getDDocument().createConnection(model.getId(), source, target);
        return new EElement(model, (DElement)connection);
    }

    protected EElement createActor(String name) {
        TActor tElement = this.getTDocument().createActor(name);
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    protected EElement createSequenciableObject(String name) {
        TSequenciableObject tElement = this.getTDocument().createSequenciableObject(name);
        DNode dNode = this.getDDocument().createNode(tElement.getId());
        return new EElement(tElement, (DElement)dNode);
    }

    public void prepareSequenceModel() {
        TPackage namespace = this.getPackage();
        String id = this.getDDocument().getId();
        TModelElement diagramModel = this.getTDocument().getTElement(id);
        if (diagramModel != null && diagramModel instanceof TSequenceModel) {
            this.sequenceModel = (TSequenceModel)diagramModel;
        } else {
            this.sequenceModel = this.getTDocument().createSequenceModel();
            this.getTDocument().addOwnedElement(namespace, this.sequenceModel);
            this.getDDocument().setId(this.sequenceModel.getId());
        }
    }

    public TElement getDiagramOwner() {
        return this.sequenceModel;
    }

    protected TDocument createInitialTDocument() {
        return new TDocument();
    }
}

