/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.CBPlugin;
import org.boxed_economy.componentbuilder.CBProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import sdeditor.SDEditorException;

public class CBCreateBoxProjectWizard
extends NewElementWizard
implements INewWizard {
    private static final Logger logger;
    private static final String WIZARD_TITLE = "Create Boxed Economy Project";
    private static final String WIZARD_MAINPAGE_TITLE = "Create Boxed Economy Project";
    private static final String WIZARD_MAINPAGE_DESCRIPTION = "Create Project for Boxed Economy";
    private static final String BESP_LIB = "lib";
    private static final String BESPJAR = "besp.jar";
    private WizardNewProjectCreationPage newProjectCreationPage;
    private NewJavaProjectWizardPage newJavaProjectPage;
    private IConfigurationElement fConfigElement;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.CBCreateBoxProjectWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public CBCreateBoxProjectWizard() {
        this.setDefaultPageImageDescriptor(CBPlugin.getDefault().getBannerImg("BigIcon_Box.gif"));
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle("Create Boxed Economy Project");
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public void addPages() {
        this.newProjectCreationPage = new WizardNewProjectCreationPage("Page 1");
        this.newProjectCreationPage.setTitle("Create Boxed Economy Project");
        this.newProjectCreationPage.setDescription(WIZARD_MAINPAGE_DESCRIPTION);
        this.addPage((IWizardPage)this.newProjectCreationPage);
        IWorkspaceRoot root = JavaPlugin.getWorkspace().getRoot();
        this.newJavaProjectPage = new NewJavaProjectWizardPage(root, this.newProjectCreationPage);
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(this.newJavaProjectPage.getRunnable());
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
            this.initializeBESPJar();
            this.initializeLibrary();
            this.initializeBBProject();
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        }
        catch (Exception ex) {
            throw new SDEditorException("caught exception in ProjectWizard", ex);
        }
        return true;
    }

    private void initializeBESPJar() {
        try {
            List libraries = this.getCurrentClasspathEntries();
            IPath bespPath = this.getBespJarPath();
            IClasspathEntry entry = JavaCore.newVariableEntry((IPath)bespPath, null, null);
            libraries.add(entry);
            this.getJavaProject().setRawClasspath(libraries.toArray(new IClasspathEntry[libraries.size()]), null);
        }
        catch (Exception ex) {
            throw new SDEditorException("Exception in Initialize besp.jar", ex);
        }
    }

    public void initializeLibrary() {
        try {
            List jars = this.getJars();
            this.getJavaProject().setRawClasspath(jars.toArray(new IClasspathEntry[jars.size()]), null);
        }
        catch (Exception ex) {
            throw new SDEditorException("Exception in Initialize Library", ex);
        }
    }

    private void initializeBBProject() {
        CBProject.getProject(this.getJavaProject().getProject());
    }

    protected List getJars() throws CoreException {
        File libFolder = this.getBespLibraryPath(true).toFile();
        if (!libFolder.exists()) {
            return Collections.EMPTY_LIST;
        }
        File[] libFiles = libFolder.listFiles();
        List jars = this.getCurrentClasspathEntries();
        int i = 0;
        while (i < libFiles.length) {
            File file = libFiles[i];
            if (file.isFile() && (file.getName().endsWith(".jar") || file.getName().endsWith(".zip"))) {
                IPath libPath = this.getBespLibraryPath(false).append(file.getName());
                IClasspathEntry entry = JavaCore.newVariableEntry((IPath)libPath, null, null);
                jars.add(entry);
            }
            ++i;
        }
        return jars;
    }

    private List getCurrentClasspathEntries() throws JavaModelException {
        ArrayList<IClasspathEntry> jars = new ArrayList<IClasspathEntry>();
        IClasspathEntry[] entries = this.getJavaProject().getRawClasspath();
        jars.addAll(Arrays.asList(entries));
        return jars;
    }

    private IJavaProject getJavaProject() {
        IJavaProject javaProject = this.newJavaProjectPage.getNewJavaProject();
        return javaProject;
    }

    private IPath getBespJarPath() {
        IPath variablePath = CBPlugin.getDefault().getBespClasspathVariable(false);
        IPath bespPath = variablePath.append(BESPJAR);
        return bespPath;
    }

    private IPath getBespLibraryPath(boolean absolute) {
        IPath variablePath = CBPlugin.getDefault().getBespClasspathVariable(absolute);
        IPath libPath = variablePath.append(BESP_LIB);
        return libPath;
    }
}

