/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.part.ISetSelectionTarget;

public class CBCreateFileWizardPage
extends WizardNewFileCreationPage {
    private Text containerText;
    private Text fileText;
    private static int exampleCount = 1;
    private String exampleName;
    private String extension;

    public CBCreateFileWizardPage(IStructuredSelection selection, String exampleName, String extension) {
        super("Hoge", selection);
        this.exampleName = exampleName;
        this.extension = extension;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        super.setFileName(String.valueOf(this.exampleName) + exampleCount);
        Composite cfr_ignored_0 = (Composite)this.getControl();
        super.setPageComplete(this.validatePage());
    }

    public boolean finish() {
        String fileName = this.getFileName();
        if (!fileName.endsWith(this.extension)) {
            super.setFileName(String.valueOf(fileName) + this.extension);
        }
        boolean retValue = super.validatePage();
        final IFile file = this.createNewFile();
        if (retValue && file != null) {
            Shell shell = this.getShell();
            IWorkbenchPage page = JavaPlugin.getActivePage();
            if (shell == null || page == null) {
                return true;
            }
            final IWorkbenchPart focusPart = page.getActivePart();
            if (focusPart instanceof ISetSelectionTarget) {
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        StructuredSelection selection = new StructuredSelection((Object)file);
                        ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                    }
                });
            }
            try {
                page.openEditor(file);
                return true;
            }
            catch (PartInitException e) {
                ExceptionHandler.handle((CoreException)e, (Shell)shell, (String)NewWizardMessages.getString((String)"NewSnippetFileWizardPage.open_error.message"), (String)e.getMessage());
            }
        }
        return false;
    }
}

