/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder;

import java.util.List;
import org.boxed_economy.componentbuilder.communicationdesigner.model.CEDocument;
import org.boxed_economy.componentbuilder.modeldesigner.model.MEDocument;
import trier.Trier;
import trier.model.core.TDocument;
import trier.model.core.TModelElement;
import trier.model.core.TNamespace;
import trier.model.core.TStereoType;

public class ComponentBuilder
extends Trier {
    static {
        Trier.INSTANCE = new ComponentBuilder();
    }

    protected ComponentBuilder() {
    }

    protected TDocument createNewDocument() {
        TDocument tdoc = super.createNewDocument();
        this.buildDefaultTEModel(tdoc);
        this.buildDefaultMEModel(tdoc);
        return tdoc;
    }

    protected void buildDefaultMEModel(TDocument document) {
        document.getDefaultPackage();
        int i = 0;
        while (i < MEDocument.DEFAULT_STEREO_TYPES.length) {
            this.getDefinedStereoType(document, MEDocument.DEFAULT_STEREO_TYPES[i]);
            ++i;
        }
    }

    protected void buildDefaultTEModel(TDocument document) {
        document.getDefaultPackage();
        int i = 0;
        while (i < CEDocument.DEFAULT_MESSAGE_STEREO_TYPES.length) {
            this.getDefinedStereoType(document, CEDocument.DEFAULT_MESSAGE_STEREO_TYPES[i]);
            ++i;
        }
    }

    protected TStereoType getDefinedStereoType(TDocument document, String name) {
        List stereoTypes = document.getDefaultPackage().getOwnedElements(document.getModelCore().getTStereoTypeClass(), name);
        if (stereoTypes.size() != 1) {
            TStereoType stereoType = document.createStereoType(name);
            document.addOwnedElement((TNamespace)document.getDefaultPackage(), (TModelElement)stereoType);
            return stereoType;
        }
        return (TStereoType)stereoTypes.get(0);
    }
}

