/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.codegen;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.codegen.CBNameMapper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.core.jdom.IDOMType;
import sdeditor.SDEditorException;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDDocument;
import sdeditor.model.SDElement;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDHistoryState;
import sdeditor.model.SDInitialState;
import sdeditor.model.SDInternalAction;
import sdeditor.model.SDInternalGuardCondition;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTemplateAction;
import sdeditor.model.SDTemplateEvent;
import sdeditor.model.SDTemplateGuardCondition;
import sdeditor.model.SDTerminalState;
import sdeditor.model.SDTransition;

public class CBCodeGeneratorCore {
    private static final Logger logger;
    public static final String CR = "\n";
    public static final String NAME_INITMETHOD = "initializeStateMachine";
    private String clName = null;
    private SDDocument document = null;
    private CBNameMapper namer = new CBNameMapper();
    private DOMFactory domFactory = null;
    private IDOMCompilationUnit domUnit = null;
    private IDOMType type = null;
    private IDOMMethod initMethod = null;
    private Block factoryBlock = new Block();
    private Block createStateBlock = new Block();
    private Block createActionBlock = new Block();
    private Block createGuardConditionBlock = new Block();
    private Block createTransitionBlock = new Block();
    private Block setStateBlock = new Block();
    private Block constructStateBlock = new Block();
    private Block setTransitionBlock = new Block();
    private Block connectTransitionBlock = new Block();
    private Set transitions = new HashSet();
    private Set actions = new HashSet();
    private Set guardConditions = new HashSet();
    private Set imports = new TreeSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.codegen.CBCodeGeneratorCore");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public CBCodeGeneratorCore(String clName, SDDocument document) {
        this.clName = clName;
        this.document = document;
    }

    public String generateContents(IProgressMonitor monitor, String oldContents) {
        this.initializeDOM(oldContents);
        this.initializeType();
        this.initializeInitMethod();
        this.processStateMachine(this.document.getRootStateMachine());
        this.processTransitions();
        this.processActions();
        this.processGuardConditions();
        this.composeInitMethod();
        this.composeImports();
        return this.domUnit.getContents();
    }

    private void initializeDOM(String oldContents) {
        this.domFactory = new DOMFactory();
        this.domUnit = this.domFactory.createCompilationUnit(oldContents, "root");
    }

    private void initializeType() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jdt.core.jdom.IDOMType");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.type = (IDOMType)this.findNode((IDOMNode)this.domUnit, this.clName, clazz);
        if (this.type != null) {
            this.type.remove();
        }
        this.type = this.createType(this.clName);
        this.domUnit.addChild((IDOMNode)this.type);
    }

    private void initializeInitMethod() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.jdom.IDOMMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.initMethod = (IDOMMethod)this.findNode((IDOMNode)this.type, NAME_INITMETHOD, clazz);
        if (this.initMethod == null) {
            this.initMethod = this.createInitializeMethod(NAME_INITMETHOD);
            this.type.addChild((IDOMNode)this.initMethod);
        }
    }

    private void composeImports() {
        Iterator i = this.imports.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (this.domUnit.getChild(name) != null) continue;
            IDOMImport iimport = this.domFactory.createImport();
            iimport.setName(name);
            this.type.insertSibling((IDOMNode)iimport);
        }
    }

    private void composeInitMethod() {
        MethodBlock initBlock = new MethodBlock();
        this.factoryBlock.addStatement(String.valueOf(this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.StateMachineFactory")) + " factory = this.getStateMachine()");
        this.factoryBlock.setComment("//factory");
        this.createStateBlock.setComment("//states");
        this.createActionBlock.setComment("//actions");
        this.createGuardConditionBlock.setComment("//guard-conditions");
        this.createTransitionBlock.setComment("//transitions");
        this.setStateBlock.setComment("//states setting");
        this.constructStateBlock.setComment("//structure of states");
        this.setTransitionBlock.setComment("//transitions setting");
        this.connectTransitionBlock.setComment("//connection of transitions");
        initBlock.addStatement(this.factoryBlock);
        initBlock.addStatement(this.createStateBlock);
        initBlock.addStatement(this.createActionBlock);
        initBlock.addStatement(this.createGuardConditionBlock);
        initBlock.addStatement(this.createTransitionBlock);
        initBlock.addStatement(this.setStateBlock);
        initBlock.addStatement(this.constructStateBlock);
        initBlock.addStatement(this.setTransitionBlock);
        initBlock.addStatement(this.connectTransitionBlock);
        this.initMethod.setBody(initBlock.toString());
    }

    private void processStateMachine(SDStateMachine statemachine) {
        List states = statemachine.getAllStates();
        Iterator i = states.iterator();
        while (i.hasNext()) {
            SDState state = (SDState)i.next();
            this.processState(state);
            this.writeAddStateToStateMachine(statemachine, state);
        }
    }

    private void processState(SDState state) {
        this.writeCreateState(state);
        this.transitions.addAll(state.getSourceTransitions());
        if (state instanceof SDCompositeState) {
            this.processSDState((SDCompositeState)state);
        }
    }

    private void processSDState(SDCompositeState state) {
        this.actions.addAll(state.getAllActions());
        Iterator i = state.getEntryActions().iterator();
        while (i.hasNext()) {
            this.writeAddActionToState(state, (SDAction)i.next(), "addEntryAction");
        }
        i = state.getDoActions().iterator();
        while (i.hasNext()) {
            this.writeAddActionToState(state, (SDAction)i.next(), "addDoAction");
        }
        i = state.getExitActions().iterator();
        while (i.hasNext()) {
            this.writeAddActionToState(state, (SDAction)i.next(), "addExitAction");
        }
        this.processStateMachine(state);
    }

    private void processTransitions() {
        Iterator i = this.transitions.iterator();
        while (i.hasNext()) {
            this.processTransition((SDTransition)i.next());
        }
    }

    private void processTransition(SDTransition transition) {
        this.guardConditions.add(transition.getGuardCondition());
        this.actions.addAll(transition.getActions());
        this.writeCreateTransition(transition);
        this.writeSetEventToTransition(transition);
        this.writeSetGuardCondtionToTransition(transition);
        Iterator i = transition.getActions().iterator();
        while (i.hasNext()) {
            this.writeAddActionToTransition(transition, (SDAction)i.next());
        }
        this.writeAddSourceToTransition(transition);
        this.writeAddTargetToTransition(transition);
    }

    private void processActions() {
        Iterator i = this.actions.iterator();
        while (i.hasNext()) {
            this.writeCreateAction((SDAction)i.next());
        }
    }

    private void processGuardConditions() {
        Iterator i = this.guardConditions.iterator();
        while (i.hasNext()) {
            this.writeCreateGuardCondition((SDGuardCondition)i.next());
        }
    }

    private IDOMType createType(String name) {
        IDOMType rootClass = this.domFactory.createClass();
        rootClass.setFlags(1);
        rootClass.setName(name);
        Javadoc javadoc = new Javadoc();
        javadoc.addStatement(name);
        rootClass.setComment(javadoc.toString());
        rootClass.setSuperclass(this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.AbstractBehavior"));
        rootClass.setFlags(1025);
        return rootClass;
    }

    private IDOMMethod createInitPlugin() {
        IDOMMethod method = this.domFactory.createMethod();
        method.setFlags(9);
        method.setName("initPlugin");
        method.setParameters(new String[]{"Container"}, new String[]{"container"});
        return method;
    }

    private IDOMMethod createInitializeMethod(String name) {
        IDOMMethod method = this.domFactory.createMethod();
        method.setFlags(4);
        method.setName(name);
        Javadoc javadoc = new Javadoc();
        javadoc.addStatement("This method automatically generated from Boxed Economy Behavior Editor.");
        javadoc.addStatement("Don't modify this method.");
        method.setComment(javadoc.toString());
        return method;
    }

    private IDOMMethod createAction(String name) {
        IDOMMethod method = this.domFactory.createMethod();
        method.setComment("/**\n*" + name + "\n*/");
        method.setFlags(1028);
        method.setName(name);
        method.setBody(";\n");
        return method;
    }

    private IDOMMethod createGuardCondition(String name) {
        IDOMMethod method = this.domFactory.createMethod();
        method.setComment("/**\n*" + name + "\n*/");
        method.setFlags(1028);
        method.setName(name);
        method.setParameters(new String[]{this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.Event")}, new String[]{"e"});
        method.setReturnType("boolean");
        method.setBody(";\n");
        return method;
    }

    private void writeCreateState(SDState state) {
        String instanceName = this.namer.getName(state);
        String left = null;
        String right = null;
        if (state instanceof SDCompositeState) {
            left = this.exDeclaration("org.boxed_economy.besp.model.fmfw.behavior.CompositeState", instanceName);
            right = this.exInvokeMethod("factory", this.getCreateMethodName(state), new Augment("\"" + state.getName() + "\""));
        } else {
            left = this.exDeclaration("org.boxed_economy.besp.model.fmfw.behavior.State", instanceName);
            right = this.exInvokeMethod("factory", this.getCreateMethodName(state), null);
        }
        String statement = this.exSubstitute(left, right);
        this.createStateBlock.addStatement(statement);
    }

    private void writeCreateTransition(SDTransition transition) {
        String name = this.namer.getName(transition);
        String left = this.exDeclaration("org.boxed_economy.besp.model.fmfw.behavior.Transition", name);
        String right = "factory.createTransition()";
        String statement = this.exSubstitute(left, right);
        this.createTransitionBlock.addStatement(statement);
    }

    private void writeCreateAction(SDAction action) {
        if (action instanceof SDTemplateAction) {
            this.writeCreateTemplateAction((SDTemplateAction)action);
        } else {
            this.writeCreateInternalAction((SDInternalAction)action);
        }
    }

    private void writeCreateGuardCondition(SDGuardCondition guard) {
        if (guard == SDTransition.defaultGuardCondition) {
            return;
        }
        if (guard instanceof SDTemplateGuardCondition) {
            this.writeCreateTemplateGuardCondition((SDTemplateGuardCondition)guard);
        } else {
            this.writeCreateInternalGuardCondition((SDInternalGuardCondition)guard);
        }
    }

    private void writeCreateInternalAction(SDInternalAction action) {
        String name = this.namer.getName(action);
        String left = this.exDeclaration("org.boxed_economy.besp.model.fmfw.behavior.Action", name);
        String right = String.valueOf(this.exNewInstance("org.boxed_economy.besp.model.fmfw.behavior.Action", null)) + "{public void doAction(){" + name + "();}public String toString(){return \"" + name + "\";}}";
        String createStatement = this.exSubstitute(left, right);
        this.createActionBlock.addStatement(createStatement);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.jdom.IDOMMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.findNode((IDOMNode)this.type, name, clazz) == null) {
            IDOMMethod method = this.createAction(name);
            this.type.addChild((IDOMNode)method);
        }
    }

    private void writeCreateInternalGuardCondition(SDInternalGuardCondition guard) {
        String name = this.namer.getName(guard);
        String decl = this.exDeclaration("org.boxed_economy.besp.model.fmfw.behavior.GuardCondition", name);
        String newIns = "new " + this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.GuardCondition") + "()" + "{public boolean isMatched(" + this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.Event") + " e) {return " + name + "(e);}}";
        String statement = this.exSubstitute(decl, newIns);
        this.createGuardConditionBlock.addStatement(statement);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.jdom.IDOMMethod");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.findNode((IDOMNode)this.type, name, clazz) == null) {
            IDOMMethod method = this.createGuardCondition(name);
            this.type.addChild((IDOMNode)method);
        }
    }

    private void writeCreateTemplateAction(SDTemplateAction action) {
        String name = this.namer.getName(action);
        String className = this.getClassName(action.getType().getFQCN());
        String left = this.exDeclaration(this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.TemplateAction"), name);
        String right = this.exNewInstance(className, null);
        String createStatement = this.exSubstitute(left, right);
        this.createActionBlock.addStatement(createStatement);
        String setStatement = this.exInvokeMethod(name, "setBehavior", new Augment("this"));
        this.createActionBlock.addStatement(setStatement);
    }

    private void writeCreateTemplateGuardCondition(SDTemplateGuardCondition guard) {
        String name = this.namer.getName(guard);
        String className = this.getClassName(guard.getType().getFQCN());
        String left = this.exDeclaration(this.getClassName("org.boxed_economy.besp.model.fmfw.behavior.TemplateGuardCondition"), name);
        String right = this.exNewInstance(className, null);
        String createStatement = this.exSubstitute(left, right);
        this.createGuardConditionBlock.addStatement(createStatement);
        String statement2 = this.exInvokeMethod(name, "setBehavior", new Augment("this"));
        this.createGuardConditionBlock.addStatement(statement2);
    }

    private void writeAddStateToStateMachine(SDStateMachine statemachine, SDState state) {
        String methodName = this.getStateAddMethodName(state);
        String containerName = this.namer.getName(statemachine);
        String stateName = this.namer.getName(state);
        String statement = this.exInvokeMethod(containerName, methodName, new Augment(stateName));
        this.constructStateBlock.addStatement(statement);
    }

    private void writeAddActionToState(SDCompositeState state, SDAction action, String methodName) {
        String stateName = this.namer.getName(state);
        String actionName = this.namer.getName(action);
        String statement = this.exInvokeMethod(stateName, methodName, new Augment(actionName));
        this.setStateBlock.addStatement(statement);
    }

    private void writeSetEventToTransition(SDTransition transition) {
        if (transition.getEvent() == SDTransition.defaultEvent) {
            return;
        }
        String name = this.namer.getName(transition);
        SDEvent event = transition.getEvent();
        String type = event instanceof SDTemplateEvent ? this.getClassName(((SDTemplateEvent)event).getType().getFQCN()) : event.getName();
        type = String.valueOf(type) + ".class";
        String statement = this.exInvokeMethod(name, "setEvent", new Augment(type));
        this.setTransitionBlock.addStatement(statement);
    }

    private void writeSetGuardCondtionToTransition(SDTransition transition) {
        if (transition.getGuardCondition() == SDTransition.defaultGuardCondition) {
            return;
        }
        String name = this.namer.getName(transition);
        String guardName = this.namer.getName(transition.getGuardCondition());
        String statement = this.exInvokeMethod(name, "setGuardCondition", new Augment(guardName));
        this.setTransitionBlock.addStatement(statement);
    }

    private void writeAddActionToTransition(SDTransition transition, SDAction action) {
        String name = this.namer.getName(transition);
        String actionName = this.namer.getName(action);
        String statement = this.exInvokeMethod(name, "addAction", new Augment(actionName));
        this.setTransitionBlock.addStatement(statement);
    }

    private void writeAddSourceToTransition(SDTransition transition) {
        String sourceName = this.namer.getName(transition.getSourceState());
        String transitionName = this.namer.getName(transition);
        String statement = this.exInvokeMethod(transitionName, "setSourceState", new Augment(sourceName));
        this.connectTransitionBlock.addStatement(statement);
    }

    private void writeAddTargetToTransition(SDTransition transition) {
        String targetName = this.namer.getName(transition.getTargetState());
        String transitionName = this.namer.getName(transition);
        String statement = this.exInvokeMethod(transitionName, "setTargetState", new Augment(targetName));
        this.connectTransitionBlock.addStatement(statement);
    }

    private String getStateAddMethodName(SDState state) {
        if (state instanceof SDCompositeState) {
            return "addState";
        }
        if (state instanceof SDInitialState) {
            return "setInitialState";
        }
        if (state instanceof SDTerminalState) {
            return "addTerminalState";
        }
        if (state instanceof SDHistoryState) {
            return "setHistoryState";
        }
        throw new SDEditorException("Illegal SDState in generate");
    }

    private String getCreateMethodName(SDElement elem) {
        if (elem instanceof SDTransition) {
            return "createTransition";
        }
        if (elem instanceof SDCompositeState) {
            return "createCompositeState";
        }
        if (elem instanceof SDInitialState) {
            return "createInitialState";
        }
        if (elem instanceof SDTerminalState) {
            return "createTerminalState";
        }
        if (elem instanceof SDHistoryState) {
            return "createHistoryState";
        }
        throw new SDEditorException("Illegal SDElement in generate by factory");
    }

    private IDOMNode findNode(IDOMNode parent, String name, Class type) {
        Enumeration e = parent.getChildren();
        while (e.hasMoreElements()) {
            IDOMNode node = (IDOMNode)e.nextElement();
            if (!node.getName().equals(name) || !type.isInstance(node)) continue;
            return node;
        }
        return null;
    }

    private String exInvokeMethod(String target, String method, Augment aug) {
        if (aug == null) {
            aug = new Augment();
        }
        return String.valueOf(target) + "." + method + aug.toString();
    }

    private String exDeclaration(String type, String name) {
        return String.valueOf(this.getClassName(type)) + " " + name;
    }

    private String exSubstitute(String left, String right) {
        return String.valueOf(left) + "=" + right;
    }

    private String exNewInstance(String type, Augment aug) {
        if (aug == null) {
            aug = new Augment();
        }
        return "new " + this.getClassName(type) + aug.toString();
    }

    private String getClassName(String fqcn) {
        this.addImport(fqcn);
        return this.trimToClass(fqcn);
    }

    private String trimToClass(String fqcn) {
        int index = fqcn.lastIndexOf(".");
        if (index == -1) {
            return fqcn;
        }
        return fqcn.substring(index + 1);
    }

    private void addImport(String importName) {
        if (importName != null && importName.length() > 0 && importName.indexOf(".") != -1) {
            this.imports.add(importName);
        }
    }

    class Block {
        private String comment = null;
        private List statements = new ArrayList();

        Block() {
        }

        public void addStatement(Object statement) {
            this.statements.add(statement);
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.comment != null) {
                buf.append(this.comment);
                buf.append(CBCodeGeneratorCore.CR);
            }
            int len = this.statements.size();
            int i = 0;
            while (i < len) {
                buf.append(this.statements.get(i).toString());
                buf.append(";");
                buf.append(CBCodeGeneratorCore.CR);
                ++i;
            }
            return buf.toString();
        }
    }

    class MethodBlock {
        private List statements = new ArrayList();

        MethodBlock() {
        }

        public void addStatement(Object statement) {
            this.statements.add(statement);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("{");
            buf.append(CBCodeGeneratorCore.CR);
            int len = this.statements.size();
            int i = 0;
            while (i < len) {
                buf.append(this.statements.get(i).toString());
                buf.append(CBCodeGeneratorCore.CR);
                ++i;
            }
            buf.append("}");
            buf.append(CBCodeGeneratorCore.CR);
            buf.append(CBCodeGeneratorCore.CR);
            buf.append(CBCodeGeneratorCore.CR);
            return buf.toString();
        }
    }

    class Augment {
        private List statements = new ArrayList();

        Augment() {
        }

        Augment(String statement) {
            this.addStatement(statement);
        }

        public void addStatement(String statement) {
            this.statements.add(statement);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("(");
            int len = this.statements.size();
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append(this.statements.get(i));
                ++i;
            }
            buf.append(")");
            return buf.toString();
        }
    }

    class Javadoc {
        private List statements = new ArrayList();

        Javadoc() {
        }

        public void addStatement(String statement) {
            this.statements.add(statement);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append(CBCodeGeneratorCore.CR);
            buf.append("/**");
            int len = this.statements.size();
            int i = 0;
            while (i < len) {
                buf.append(CBCodeGeneratorCore.CR);
                buf.append("* ");
                buf.append(this.statements.get(i));
                ++i;
            }
            buf.append(CBCodeGeneratorCore.CR);
            buf.append("*/");
            buf.append(CBCodeGeneratorCore.CR);
            return buf.toString();
        }
    }
}

