/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import trier.model.core.TAttribute;
import trier.model.core.TClass;
import trier.model.core.TClassifier;
import trier.model.core.TDataType;
import trier.model.core.TGeneralization;
import trier.model.core.TMethod;
import trier.model.core.TParameter;

public class MEInformationCodegenHelper {
    Set imports = new HashSet();
    List implementedSuperTypes = new ArrayList();
    List extendedSuperTypes = new ArrayList();
    TClass information;

    public MEInformationCodegenHelper(TClass information) {
        this.information = information;
        this.init(information);
    }

    private void init(TClass information) {
        this.searchSuperTypes(information);
        this.importAttributeType(information);
        this.importMethodType(information);
    }

    private void searchSuperTypes(TClass information) {
        Iterator i = information.getReferedGeneralizations().iterator();
        while (i.hasNext()) {
            TGeneralization generalization = (TGeneralization)i.next();
            if (!generalization.getChildClass().equals((Object)information)) continue;
            if (!generalization.isImplementation()) {
                this.extendedSuperTypes.add(generalization.getParentClass());
                this.addImport((TClassifier)generalization.getParentClass());
                continue;
            }
            this.implementedSuperTypes.add(generalization.getParentClass());
            this.addImport((TClassifier)generalization.getParentClass());
        }
        if (this.extendedSuperTypes.isEmpty()) {
            this.imports.add("org.boxed_economy.besp.model.fmfw.AbstractInformation");
        }
    }

    private void importMethodType(TClass information) {
        Iterator i = information.getMethods().iterator();
        while (i.hasNext()) {
            TMethod method = (TMethod)i.next();
            this.addImport(method.getType());
        }
    }

    private void importAttributeType(TClass information) {
        Iterator i = information.getAttributes().iterator();
        while (i.hasNext()) {
            TAttribute attribute = (TAttribute)i.next();
            this.addImport(attribute.getType());
        }
    }

    private void addImport(TClassifier classifier) {
        if (classifier instanceof TClass && !classifier.isNull() && !classifier.getNamespace().getName().equals("default") && !classifier.getNamespace().equals((Object)this.information.getNamespace())) {
            this.imports.add(String.valueOf(classifier.getNamespace().toString()) + "." + classifier.getName());
        }
    }

    public boolean isValidGeneralization() {
        return this.extendedSuperTypes.size() <= 1;
    }

    public String getInformationName() {
        return this.information.getName();
    }

    public String getInformationPackage() {
        return this.information.getNamespace().toString();
    }

    public String getGeneralizationDeclaration() {
        StringBuffer buf = new StringBuffer();
        buf.append("extends ");
        if (this.extendedSuperTypes.isEmpty()) {
            buf.append("AbstractInformation ");
        } else {
            buf.append(String.valueOf(((TClass)this.extendedSuperTypes.get(0)).getName()) + " ");
        }
        if (!this.implementedSuperTypes.isEmpty()) {
            buf.append("implements ");
            Iterator i = this.implementedSuperTypes.iterator();
            while (i.hasNext()) {
                TClass superType = (TClass)i.next();
                buf.append(String.valueOf(superType.getName()) + " ");
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
        }
        return buf.toString();
    }

    public List getImports() {
        ArrayList importsAsList = new ArrayList(this.imports);
        Collections.sort(importsAsList);
        return importsAsList;
    }

    public String getAttributeDeclaration(TAttribute attribute) {
        StringBuffer buf = new StringBuffer();
        buf.append(attribute.getVisibilityKind().toString());
        if (attribute.isStatic()) {
            buf.append(" static");
        }
        if (attribute.isAbstract()) {
            buf.append(" abstract");
        }
        if (attribute.isFinal()) {
            buf.append(" final");
        }
        buf.append(" " + attribute.getType().getName() + " " + attribute.getName() + ";");
        return buf.toString();
    }

    public String getMethodDeclaration(TMethod method) {
        StringBuffer buf = new StringBuffer();
        buf.append(method.getVisibilityKind().toString());
        if (method.isStatic()) {
            buf.append(" static");
        }
        if (method.isAbstract()) {
            buf.append(" abstract");
        }
        if (method.isFinal()) {
            buf.append(" final");
        }
        if (method.getType().isNull()) {
            buf.append(" void");
        } else {
            buf.append(" " + method.getType().getName());
        }
        buf.append(" " + method.getName());
        buf.append(this.getParametersAsString(method));
        return buf.toString();
    }

    public String getMethodReturnCode(TMethod method) {
        TClassifier type = method.getType();
        if (type.isNull()) {
            return "";
        }
        if (type instanceof TDataType) {
            if (type.getName().equals("boolean")) {
                return "return false;";
            }
            if (type.getName().equals("String")) {
                return "return null;";
            }
            return "return 0;";
        }
        return "return null;";
    }

    private String getParametersAsString(TMethod method) {
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        Iterator i = method.getParameters().iterator();
        while (i.hasNext()) {
            TParameter parameter = (TParameter)i.next();
            this.addImport(parameter.getType());
            buf.append(parameter.toString());
            if (!i.hasNext()) continue;
            buf.append(",");
        }
        buf.append(")");
        return buf.toString();
    }

    public TClass getInformation() {
        return this.information;
    }

    public List getAttributes() {
        return this.information.getAttributes();
    }

    public List getMethods() {
        return this.information.getMethods();
    }
}

