/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.codegen;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.boxed_economy.componentbuilder.modeldesigner.model.MEDocument;
import trier.model.core.TClass;
import trier.model.core.TGeneralization;
import trier.model.core.TPackage;

public class MEModelCodegenHelper {
    public static String RELATION_TYPE = "RelationType";
    public static String AGENT_TYPE = "AgentType";
    public static String INFORMATION_TYPE = "InformationType";
    public static String GOODS_TYPE = "GoodsType";
    public static String BEHAVIOR_TYPE = "BehaviorType";
    private MEDocument document;
    private String name;
    private Set imports = new HashSet();
    private String sameTypeName = "";

    public MEModelCodegenHelper(MEDocument document) {
        this.document = document;
        this.init();
    }

    private void init() {
    }

    public String generateTypeDeclaration(TClass type) {
        StringBuffer buf = new StringBuffer();
        buf.append("public static ");
        buf.append(String.valueOf(this.getTypeType(type)) + " ");
        buf.append(this.getTypeVariableName(type));
        buf.append(";");
        return buf.toString();
    }

    public String generateTypeInstallation(TClass type) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getTypeVariableName(type));
        buf.append("=");
        buf.append("modelContainer.install" + this.getTypeType(type) + "(\"" + type.getNamespace().toString() + "." + type.getName() + "\")");
        buf.append(";");
        return buf.toString();
    }

    public List generateTypeInheritance(TClass type) {
        ArrayList<String> generateTokens = new ArrayList<String>();
        Iterator i = type.getReferedGeneralizations().iterator();
        while (i.hasNext()) {
            TClass childType;
            TGeneralization generalization = (TGeneralization)i.next();
            if (!generalization.getParentClass().equals((Object)type) || !(childType = generalization.getChildClass()).getStereoType().equals((Object)type.getStereoType())) continue;
            StringBuffer buf = new StringBuffer();
            buf.append(String.valueOf(this.getTypeVariableName(type)) + ".addChild(" + this.getTypeVariableName(childType) + ");");
            generateTokens.add(buf.toString());
        }
        return generateTokens;
    }

    private String getTypeVariableName(TClass type) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getTypeType(type).toUpperCase());
        buf.append("_");
        buf.append(type.getName());
        return buf.toString();
    }

    private String getTypeType(TClass type) {
        if (type.getStereoType().getName().equals("agent type")) {
            return AGENT_TYPE;
        }
        if (type.getStereoType().getName().equals("goods type")) {
            return GOODS_TYPE;
        }
        if (type.getStereoType().getName().equals("information type")) {
            return INFORMATION_TYPE;
        }
        if (type.getStereoType().getName().equals("relation type")) {
            return RELATION_TYPE;
        }
        if (type.getStereoType().getName().equals("behavior type")) {
            return BEHAVIOR_TYPE;
        }
        return "";
    }

    public boolean canGenerate() {
        HashSet<String> names = new HashSet<String>();
        Iterator i = this.getAllTypes().iterator();
        while (i.hasNext()) {
            TClass type = (TClass)i.next();
            if (names.contains(type.getName())) {
                this.sameTypeName = type.getName();
                return false;
            }
            names.add(type.getName());
        }
        return true;
    }

    public List getAllTypes() {
        return this.document.getAllType();
    }

    public TPackage getPackage() {
        return this.document.getPackage();
    }

    public String getName() {
        String projectName = this.document.getParentContainer().getProject().getName();
        String head = String.valueOf(Character.toUpperCase(projectName.charAt(0)));
        if (projectName.length() > 1) {
            return String.valueOf(head) + projectName.substring(1) + "Model";
        }
        return String.valueOf(head) + "Model";
    }

    public Set getImports() {
        return this.imports;
    }

    public String getSameTypeName() {
        return this.sameTypeName;
    }
}

