/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.modeldesigner.codegen;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class MyJETEmitter
extends JETEmitter {
    private List mClasspathEntries = new ArrayList();

    public MyJETEmitter(String templateURI) {
        super(templateURI);
    }

    public MyJETEmitter(String[] templateURIPath, String relativeTemplateURI) {
        super(templateURIPath, relativeTemplateURI);
    }

    public void addClasspathVariable(String variableName, String pluginID) throws JETException {
        IPluginDescriptor descriptor = Platform.getPlugin((String)pluginID).getDescriptor();
        ILibrary[] libraries = descriptor.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getType().equals("code")) {
                try {
                    new URL(descriptor.getInstallURL(), libraries[i].getPath().toString());
                    break;
                }
                catch (MalformedURLException e) {
                    throw new JETException((Throwable)e);
                }
            }
            ++i;
        }
        IClasspathEntry entry = JavaCore.newVariableEntry((IPath)new Path(variableName), null, null);
        this.addClasspathEntry(entry);
    }

    public void addClasspathEntry(IClasspathEntry entry) {
        this.mClasspathEntries.add(entry);
    }

    public void initialize(IProgressMonitor progressMonitor) throws JETException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(".JETEmitters");
        if (!project.exists()) {
            super.initialize(progressMonitor);
        }
        try {
            project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 5));
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] existing = javaProject.getRawClasspath();
            IClasspathEntry[] newEntries = this.addMissing(existing);
            if (newEntries.length > existing.length) {
                javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
            }
        }
        catch (CoreException e) {
            throw new JETException((Throwable)e);
        }
        super.initialize(progressMonitor);
    }

    private IClasspathEntry[] addMissing(IClasspathEntry[] existing) {
        if (this.mClasspathEntries.isEmpty()) {
            return existing;
        }
        ArrayList<IClasspathEntry> result = new ArrayList<IClasspathEntry>(this.mClasspathEntries.size() + existing.length);
        result.addAll(Arrays.asList(existing));
        Iterator i = this.mClasspathEntries.iterator();
        while (i.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)i.next();
            if (result.contains(entry)) continue;
            System.out.println("Adding '" + entry + "' to '" + result + "'");
            result.add(entry);
        }
        return result.toArray(new IClasspathEntry[result.size()]);
    }
}

