/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.codegen;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.CBPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCArgument;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCBlock;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGenerationUtil;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorConstants;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorCore;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCForLoop;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCJavadoc;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCMethodBlock;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCBehaviorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCClockSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCGoodsSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCInformationSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCWorldTemplate;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.jdom.DOMFactory;
import org.eclipse.jdt.core.jdom.IDOMCompilationUnit;
import org.eclipse.jdt.core.jdom.IDOMField;
import org.eclipse.jdt.core.jdom.IDOMImport;
import org.eclipse.jdt.core.jdom.IDOMMember;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMType;

public class WCIDOMElementFactory {
    private static final Logger logger;
    private WCCodeGeneratorCore generator;
    private WCCodeGenerationUtil util;
    private DOMFactory domFactory = null;
    private String listClassName = null;
    private String arrayListClassName = null;
    private String arraysClassName = null;
    private String agentClassName = null;
    private String behaviorClassName = null;
    private String informationClassName = null;
    private String relationClassName = null;
    private String generatorClassName = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.codegen.WCIDOMElementFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public WCIDOMElementFactory(WCCodeGeneratorCore generator) {
        this.generator = generator;
        this.util = new WCCodeGenerationUtil(generator);
        this.domFactory = new DOMFactory();
        this.initializeClassNames();
    }

    private void initializeClassNames() {
        this.listClassName = this.generator.getClassName("java.util.List");
        this.arrayListClassName = this.generator.getClassName("java.util.ArrayList");
        this.arraysClassName = this.generator.getClassName("java.util.Arrays");
        this.agentClassName = this.generator.getClassName(CBPlugin.FQCN_AGENT);
        this.generatorClassName = this.generator.getClassName(CBPlugin.FQCN_RANDOMNUMBERGENERATOR);
    }

    public IDOMField createSerialIDField() {
        return this.createConstant("long", "serialVersionUID", "1L", 2);
    }

    public IDOMField createLoggerField() {
        String log4j = this.generator.getClassName("org.apache.log4j.Logger");
        IDOMField logger = this.createConstant(log4j, "logger", this.util.exInvokeMethod(log4j, "getLogger", new WCArgument(String.valueOf(this.generator.getWorldName()) + ".class.getName()")), 2);
        return logger;
    }

    public IDOMMethod createMainMethod() {
        String besp = this.generator.getClassName("org.boxed_economy.besp.container.BESP");
        IDOMMethod main = this.mainMethod();
        WCMethodBlock mainBlock = new WCMethodBlock();
        mainBlock.addStatement(String.valueOf(this.util.exInvokeMethod(besp, "main", new WCArgument("new String[] { \"-model\"," + this.generator.getWorldName() + ".class.getName()}"))) + ";");
        main.setBody(mainBlock.toString());
        return main;
    }

    public IDOMMember createRandomNumberGeneratorKey(WCRandomNumberGeneratorSetting setting) {
        return this.createConstant("String", this.generator.getNameMapper().getName(setting), this.util.exStringLiteral(setting.getName()), 2);
    }

    public IDOMMember createParameterVariable(WCParameter parameter) {
        return this.createField(parameter.getType(), this.generator.getNameMapper().getName(parameter), this.generator.getNameMapper().getName(parameter.getValue()), 2);
    }

    public IDOMMember createRandomSeedVariable(WCRandomNumberGeneratorSetting setting, WCParameter seed) {
        return this.createField("long", this.generator.getNameMapper().getName(seed), this.generator.getNameMapper().getName(setting.getSeed()), 2);
    }

    public IDOMMember createAgentListVariable(WCAgentGroup agentGroup) {
        return this.createField(this.listClassName, WCCodeGeneratorConstants.getAgentListName(this.generator.getNameMapper().getName(agentGroup)), this.util.exNewInstance(this.arrayListClassName, new WCArgument()), 2);
    }

    public IDOMMethod createInitializeWorld(WCBlock initializeGenerator) {
        IDOMMethod initializeWorld = this.domFactory.createMethod();
        initializeWorld.setFlags(1);
        initializeWorld.setName("initializeWorld");
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement("Initialize World.");
        doc.addStatement("");
        doc.addStatement("@see org.boxed_economy.besp.model.fmfw.World#initializeWorld()");
        initializeWorld.setComment(doc.toString());
        WCMethodBlock initializeWorldBody = new WCMethodBlock();
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo("Initialize World."));
        preprocess.addStatement(this.util.exInvokeMethod("super", "initializeWorld", new WCArgument()));
        WCBlock clock = new WCBlock();
        clock.setComment(WCCodeGeneratorConstants.COMMENT_CLOCK);
        WCClockSetting clockSetting = this.generator.getDocument().getWorldTemplate().getClockSetting();
        String clockName = this.generator.getClassName(String.valueOf(clockSetting.getClockPackage()) + "." + clockSetting.getName());
        clock.addStatement(this.util.exInvokeMethod("this", "setClock", new WCArgument(this.util.exNewInstance(clockName, new WCArgument()))));
        initializeWorldBody.addStatement(preprocess);
        initializeWorldBody.addStatement(clock);
        if (!initializeGenerator.statements.isEmpty()) {
            initializeWorldBody.addStatement(initializeGenerator);
        }
        initializeWorld.setBody(initializeWorldBody.toString());
        return initializeWorld;
    }

    public String getInstallRandomNumberGeneratorStatement(WCRandomNumberGeneratorSetting setting, WCParameter seed) {
        String generatorName = this.generator.getClassName(String.valueOf(setting.getPackagename()) + "." + setting.getClassName());
        WCArgument creationArgs = new WCArgument();
        creationArgs.addStatement(this.generator.getNameMapper().getName(setting));
        creationArgs.addStatement(this.generator.getNameMapper().getName(seed));
        return this.util.exInvokeMethod("this", "installRandomNumberGenerator", new WCArgument(this.util.exNewInstance(generatorName, creationArgs)));
    }

    public IDOMMethod createInitializeAgents() {
        IDOMMethod initializeAgents = this.domFactory.createMethod();
        initializeAgents.setFlags(1);
        initializeAgents.setName("initializeAgents");
        WCMethodBlock initializeWorldBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_INITIALIZE_AGENTS);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_INITIALIZE_AGENTS);
        initializeAgents.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.COMMENT_INITIALIZE_AGENTS));
        preprocess.addStatement(this.util.exInvokeMethod("super", "initializeAgents", new WCArgument()));
        WCBlock process = new WCBlock();
        process.addStatement(this.util.exInvokeMethod("this", "createAgents", new WCArgument()));
        process.addStatement(this.util.exInvokeMethod("this", "addRelations", new WCArgument()));
        process.addStatement(this.util.exInvokeMethod("this", "initializeByHands", new WCArgument()));
        initializeWorldBody.addStatement(preprocess);
        initializeWorldBody.addStatement(process);
        initializeAgents.setBody(initializeWorldBody.toString());
        return initializeAgents;
    }

    public IDOMMethod createInitializeByHands() {
        IDOMMethod initializeByHands = this.domFactory.createMethod();
        initializeByHands.setFlags(2);
        initializeByHands.setName("initializeByHands");
        WCMethodBlock initializeWorldBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_INITIALIZE_BY_HANDS);
        initializeByHands.setComment(doc.toString());
        initializeByHands.setBody(initializeWorldBody.toString());
        return initializeByHands;
    }

    public IDOMMethod createCreateAgents(WCBlock createAgentsBlock) {
        IDOMMethod createAgents = this.domFactory.createMethod();
        createAgents.setFlags(2);
        createAgents.setName("createAgents");
        WCMethodBlock createAgentsBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_CREATE_AGENTS);
        createAgents.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.COMMENT_CREATE_AGENTS));
        createAgentsBody.addStatement(preprocess);
        createAgentsBody.addStatement(createAgentsBlock);
        createAgents.setBody(createAgentsBody.toString());
        return createAgents;
    }

    public IDOMMethod createAddRelations(WCBlock addRelationsBlock) {
        IDOMMethod addRelations = this.domFactory.createMethod();
        addRelations.setFlags(2);
        addRelations.setName("addRelations");
        WCMethodBlock addRelationsBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_ADD_REALTIONS);
        addRelations.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.COMMENT_ADD_REALTIONS));
        addRelationsBody.addStatement(preprocess);
        addRelationsBody.addStatement(addRelationsBlock);
        addRelations.setBody(addRelationsBody.toString());
        return addRelations;
    }

    public String createInvokeCreateAgentsStatement(WCAgentGroup agentGroup) {
        return this.util.exInvokeMethod("this", WCCodeGeneratorConstants.getMethodNameCreateAgent\uff53(this.generator.getNameMapper().getName(agentGroup)), new WCArgument());
    }

    public Object createInvokeCreateAgentStatement(WCAgentGroup agentGroup) {
        return this.util.exInvokeMethod("this", WCCodeGeneratorConstants.getMethodNameCreateAgent(this.generator.getNameMapper().getName(agentGroup)), new WCArgument());
    }

    public Object createInvokeAddRelationStatement(WCRelationGroup relationGroup) {
        return this.util.exInvokeMethod("this", WCCodeGeneratorConstants.getMethodNameAddRelaiton\uff53(this.generator.getNameMapper().getName(relationGroup)), new WCArgument());
    }

    public IDOMMethod createAgentsSub(WCAgentGroup agentGroup) {
        IDOMMethod createAgentsSub = this.domFactory.createMethod();
        createAgentsSub.setFlags(2);
        createAgentsSub.setName(WCCodeGeneratorConstants.getMethodNameCreateAgent\uff53(this.generator.getNameMapper().getName(agentGroup)));
        WCMethodBlock block = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.getCommentCreateAgents(this.generator.getNameMapper().getName(agentGroup)));
        createAgentsSub.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.getCommentCreateAgents(this.generator.getNameMapper().getName(agentGroup))));
        WCForLoop loop = new WCForLoop(this.createGetValueStatement(agentGroup.getNumber()));
        loop.addStatement(this.util.exInvokeMethod("this", WCCodeGeneratorConstants.getMethodNameCreateAgent(this.generator.getNameMapper().getName(agentGroup)), new WCArgument()));
        block.addStatement(preprocess);
        block.addStatement(loop);
        createAgentsSub.setBody(block.toString());
        return createAgentsSub;
    }

    public IDOMMethod createAgentSub(WCAgentGroup agentGroup) {
        IDOMMethod method = this.domFactory.createMethod();
        method.setFlags(2);
        method.setName(WCCodeGeneratorConstants.getMethodNameCreateAgent(this.generator.getNameMapper().getName(agentGroup)));
        WCMethodBlock block = new WCMethodBlock();
        String agentVariableName = WCCodeGeneratorConstants.getVariableNameAgent(this.generator.getNameMapper().getName(agentGroup));
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.getCommentCreateAgent(this.generator.getNameMapper().getName(agentGroup)));
        method.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.getCommentCreateAgent(this.generator.getNameMapper().getName(agentGroup))));
        block.addStatement(preprocess);
        WCBlock createAgent = this.createCreateAgentBlock(agentGroup, agentVariableName);
        block.addStatement(createAgent);
        if (!agentGroup.getBehaviorSettings().isEmpty()) {
            WCBlock addBehaviors = this.createAddBehaviorsBlock(agentGroup, agentVariableName);
            block.addStatement(addBehaviors);
        }
        if (!agentGroup.getGoodsSettings().isEmpty()) {
            WCBlock addGoods = this.createAddGoodsBlock(agentGroup, agentVariableName);
            block.addStatement(addGoods);
        }
        if (!agentGroup.getInformationSettings().isEmpty()) {
            WCBlock putInformation = this.createPutInformationBlock(agentGroup, agentVariableName);
            block.addStatement(putInformation);
        }
        WCBlock addToList = new WCBlock();
        String list = WCCodeGeneratorConstants.getAgentListName(this.generator.getNameMapper().getName(agentGroup));
        WCArgument arg = new WCArgument(agentVariableName);
        addToList.addStatement(this.util.exInvokeMethod(list, "add", arg));
        block.addStatement(addToList);
        method.setBody(block.toString());
        return method;
    }

    private WCBlock createCreateAgentBlock(WCAgentGroup agentGroup, String agentVariableName) {
        WCBlock createAgent = new WCBlock();
        createAgent.setComment(WCCodeGeneratorConstants.COMMENT_CREATE_AGENT);
        String left = this.util.exDeclaration(this.agentClassName, agentVariableName);
        String right = this.util.exInvokeMethod("super", "createAgent", this.util.createTypeArgument(agentGroup.getType()));
        createAgent.addStatement(this.util.exSubstitute(left, right));
        return createAgent;
    }

    private WCBlock createAddBehaviorsBlock(WCAgentGroup agentGroup, String agentVariableName) {
        WCBlock addBehaviors = new WCBlock();
        addBehaviors.setComment(WCCodeGeneratorConstants.COMMENT_ADD_BEHAVIORS);
        Iterator i = agentGroup.getBehaviorSettings().iterator();
        while (i.hasNext()) {
            WCBehaviorSetting setting = (WCBehaviorSetting)i.next();
            addBehaviors.addStatement(this.util.exInvokeMethod(agentVariableName, "addBehavior", this.util.createTypeArgument(setting.getType())));
        }
        return addBehaviors;
    }

    private WCBlock createAddGoodsBlock(WCAgentGroup agentGroup, String agentVariableName) {
        WCBlock addGoods = new WCBlock();
        addGoods.setComment(WCCodeGeneratorConstants.COMMENT_ADD_GOODS);
        String goodsClassName = this.generator.getClassName(CBPlugin.FQCN_GOODS);
        Iterator i = agentGroup.getGoodsSettings().iterator();
        while (i.hasNext()) {
            WCGoodsSetting setting = (WCGoodsSetting)i.next();
            String goodsVariableName = WCCodeGeneratorConstants.getGoodsVariableName(setting.getType().getTypeName());
            String left = this.util.exDeclaration(goodsClassName, goodsVariableName);
            String right = this.util.exInvokeMethod("super", "createGoods", this.createGoodsArgument(setting));
            addGoods.addStatement(this.util.exSubstitute(left, right));
            String addInvoke = this.util.exInvokeMethod(agentVariableName, "addGoods", new WCArgument(goodsVariableName));
            addGoods.addStatement(addInvoke);
        }
        return addGoods;
    }

    private WCBlock createPutInformationBlock(WCAgentGroup agentGroup, String agentVariableName) {
        WCBlock putInformation = new WCBlock();
        putInformation.setComment(WCCodeGeneratorConstants.COMMENT_PUT_INFORMATION);
        Iterator i = agentGroup.getInformationSettings().iterator();
        while (i.hasNext()) {
            WCInformationSetting setting = (WCInformationSetting)i.next();
            WCCodeGeneratorConstants.getInformationVariableName(setting.getType().getTypeName());
            String put = this.util.exInvokeMethod(agentVariableName, "putInformation", this.createInformationArgument(setting, agentVariableName));
            putInformation.addStatement(put);
        }
        return putInformation;
    }

    private WCArgument createGoodsArgument(WCGoodsSetting setting) {
        String quantityStatement = "";
        WCValuedExpression value = setting.getQuantity();
        quantityStatement = this.createGetValueStatement(value);
        String typeName = this.generator.getClassName(setting.getType().getModelFQCN());
        WCArgument goodsArgument = new WCArgument(String.valueOf(typeName) + "." + setting.getType().getTypeName());
        goodsArgument.addStatement(quantityStatement);
        return goodsArgument;
    }

    public IDOMMethod createAddRelationsSubroutine(WCRelationGroup relationGroup) {
        IDOMMethod addRelations = this.domFactory.createMethod();
        addRelations.setFlags(2);
        addRelations.setName(WCCodeGeneratorConstants.getMethodNameAddRelaiton\uff53(this.generator.getNameMapper().getName(relationGroup)));
        WCMethodBlock addRelationsBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.getCommentAddRelations(this.generator.getNameMapper().getName(relationGroup)));
        addRelations.setComment(doc.toString());
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.util.exLoggerInfo(WCCodeGeneratorConstants.getCommentAddRelations(this.generator.getNameMapper().getName(relationGroup))));
        addRelationsBody.addStatement(preprocess);
        WCBlock[] addRelationProcessBlocks = relationGroup.getPattern().getRelationPatternCodeGenerator(relationGroup, this.generator).getAddRelationProcess();
        int i = 0;
        while (i < addRelationProcessBlocks.length) {
            addRelationsBody.addStatement(addRelationProcessBlocks[i]);
            ++i;
        }
        addRelations.setBody(addRelationsBody.toString());
        return addRelations;
    }

    public IDOMMethod createGetName(String name) {
        String methodName = "getName";
        String comment = WCCodeGeneratorConstants.COMMENT_GET_NAME;
        String javadoc = WCCodeGeneratorConstants.JAVADOC_GET_NAME;
        String value = this.util.exStringLiteral(name);
        IDOMMethod getter = this.createGettreUtil(methodName, "String", comment, javadoc, value);
        return getter;
    }

    public IDOMMethod createGetDescription(String description) {
        String name = "getDescription";
        String comment = WCCodeGeneratorConstants.COMMENT_GET_DESCRIPTION;
        String javadoc = WCCodeGeneratorConstants.JAVADOC_GET_DESCRIPTION;
        String value = this.util.exStringLiteral(description);
        IDOMMethod getter = this.createGettreUtil(name, "String", comment, javadoc, value);
        return getter;
    }

    public IDOMMember createGetter(String variableName, String type) {
        String name = WCCodeGeneratorConstants.getMethodNameGetter(variableName);
        String comment = WCCodeGeneratorConstants.getCommentGetter(variableName);
        String javadoc = WCCodeGeneratorConstants.getJavadocGetter(variableName);
        IDOMMethod getter = this.createGettreUtil(name, type, comment, javadoc, variableName);
        return getter;
    }

    public IDOMMember createSetter(String variableName, String type) {
        IDOMMethod setter = this.domFactory.createMethod();
        setter.setFlags(1);
        setter.setParameters(new String[]{type}, new String[]{variableName});
        setter.setName(WCCodeGeneratorConstants.getMethodNameSetter(variableName));
        WCMethodBlock setterBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.getCommentSetter(variableName));
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.getJavadocSetter(variableName));
        setter.setComment(doc.toString());
        setterBody.addStatement(String.valueOf(this.util.exSubstitute("this." + variableName, variableName)) + ";");
        setter.setBody(setterBody.toString());
        return setter;
    }

    public IDOMMember createParameterDescription(String variableName, String description) {
        String name = WCCodeGeneratorConstants.getMethodNameDescription(variableName);
        String type = "String";
        String comment = WCCodeGeneratorConstants.getCommentDescription(variableName);
        String javadoc = WCCodeGeneratorConstants.getJavadocDescription(variableName);
        String returnValue = this.util.exStringLiteral(description);
        IDOMMethod getter = this.createGettreUtil(name, type, comment, javadoc, returnValue);
        return getter;
    }

    private IDOMMethod createGettreUtil(String name, String type, String comment, String javadoc, String returnValue) {
        IDOMMethod getter = this.domFactory.createMethod();
        getter.setFlags(1);
        getter.setReturnType(type);
        getter.setName(name);
        WCMethodBlock getterBody = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(comment);
        doc.addStatement("");
        doc.addStatement(javadoc);
        getter.setComment(doc.toString());
        getterBody.addStatement("return " + returnValue + ";");
        getter.setBody(getterBody.toString());
        return getter;
    }

    public IDOMMethod createInformationFactory(String factoryName, String type) {
        IDOMMethod factory = this.domFactory.createMethod();
        factory.setFlags(2);
        factory.setName(factoryName);
        factory.setReturnType(type);
        factory.setParameters(new String[]{this.agentClassName}, new String[]{"agent"});
        WCMethodBlock block = new WCMethodBlock();
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.getInformationFactoryComment(factoryName));
        factory.setComment(doc.toString());
        block.addStatement("return null;");
        factory.setBody(block.toString());
        return factory;
    }

    public IDOMMethod createGetDoubleRandomQuantity() {
        IDOMMethod randomQuantity = this.domFactory.createMethod();
        randomQuantity.setName(WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_DOUBLE);
        randomQuantity.setFlags(2);
        randomQuantity.setReturnType("double");
        randomQuantity.setParameters(new String[]{"String", "double", "double"}, new String[]{"generatorName", "max", "minimum"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_GENERATE_RANDOM_BY_DOUBLE);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_GENERATE_RANDOM);
        randomQuantity.setComment(doc.toString());
        WCMethodBlock methodBody = this.getRandomQuantityBody("double");
        randomQuantity.setBody(methodBody.toString());
        return randomQuantity;
    }

    public IDOMMethod createGetLongRandomQuantity() {
        IDOMMethod randomQuantity = this.domFactory.createMethod();
        randomQuantity.setName(WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_LONG);
        randomQuantity.setFlags(2);
        randomQuantity.setReturnType("long");
        randomQuantity.setParameters(new String[]{"String", "long", "long"}, new String[]{"generatorName", "max", "minimum"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_GENERATE_RANDOM_BY_LONG);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_GENERATE_RANDOM);
        randomQuantity.setComment(doc.toString());
        WCMethodBlock methodBody = this.getRandomQuantityBody("long");
        randomQuantity.setBody(methodBody.toString());
        return randomQuantity;
    }

    public IDOMMethod createGetIntRandomQuantity() {
        IDOMMethod randomQuantity = this.domFactory.createMethod();
        randomQuantity.setName(WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_INT);
        randomQuantity.setFlags(2);
        randomQuantity.setReturnType("int");
        randomQuantity.setParameters(new String[]{"String", "int", "int"}, new String[]{"generatorName", "max", "minimum"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_GENERATE_RANDOM_BY_INT);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_GENERATE_RANDOM);
        randomQuantity.setComment(doc.toString());
        WCMethodBlock methodBody = this.getRandomQuantityBody("int");
        randomQuantity.setBody(methodBody.toString());
        return randomQuantity;
    }

    public IDOMMethod createGenerateElectedRandomNumber() {
        IDOMMethod electedNumbers = this.domFactory.createMethod();
        electedNumbers.setName(WCCodeGeneratorConstants.METHOD_NAME_GENERATE_ELECTED);
        electedNumbers.setFlags(2);
        electedNumbers.setReturnType("int[]");
        electedNumbers.setParameters(new String[]{"String", "int", "int"}, new String[]{"generatorName", "number", "max"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_GENERATE_ELECTED);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_GENERATE_ELECTED);
        electedNumbers.setComment(doc.toString());
        WCMethodBlock methodBody = this.createGenerateElectedNumberBody();
        electedNumbers.setBody(methodBody.toString());
        return electedNumbers;
    }

    public IDOMMethod createGenerateElectedRandomNumberExcluded() {
        IDOMMethod electedNumbers = this.domFactory.createMethod();
        electedNumbers.setName(WCCodeGeneratorConstants.METHOD_NAME_GENERATE_ELECTED);
        electedNumbers.setFlags(2);
        electedNumbers.setReturnType("int[]");
        electedNumbers.setParameters(new String[]{"String", "int", "int", "int"}, new String[]{"generatorName", "number", "max", "excludedNumber"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_GENERATE_ELECTED_EXCLUDED);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_GENERATE_ELECTED_EXCLUDED);
        electedNumbers.setComment(doc.toString());
        WCMethodBlock methodBody = this.createGenerateElectedNumberExcludedBody();
        electedNumbers.setBody(methodBody.toString());
        return electedNumbers;
    }

    public IDOMMethod createIsElected() {
        IDOMMethod electedNumbers = this.domFactory.createMethod();
        electedNumbers.setName(WCCodeGeneratorConstants.METHOD_NAME_IS_ELECTED);
        electedNumbers.setFlags(2);
        electedNumbers.setReturnType("boolean");
        electedNumbers.setParameters(new String[]{"int[]", "int"}, new String[]{"electedNumbers", "target"});
        WCJavadoc doc = new WCJavadoc();
        doc.addStatement(WCCodeGeneratorConstants.COMMENT_IS_ELECTED);
        doc.addStatement("");
        doc.addStatement(WCCodeGeneratorConstants.JAVADOC_IS_ELECTED);
        electedNumbers.setComment(doc.toString());
        WCMethodBlock methodBody = this.createIsElectedBody();
        electedNumbers.setBody(methodBody.toString());
        return electedNumbers;
    }

    private WCMethodBlock getRandomQuantityBody(String type) {
        WCMethodBlock methodBody = new WCMethodBlock();
        WCBlock preprocess = new WCBlock();
        String left = this.util.exDeclaration(this.generatorClassName, "generator");
        String right = this.util.exInvokeMethod("super", "getRandomNumberGenerator", new WCArgument("generatorName"));
        preprocess.addStatement(this.util.exSubstitute(left, right));
        methodBody.addStatement(preprocess);
        WCBlock process = new WCBlock();
        process.setComment(WCCodeGeneratorConstants.COMMENT_GENERATE_RANDOM);
        process.addStatement(this.util.exSubstitute(this.util.exDeclaration("double", "randomNumber"), this.util.exInvokeMethod("generator", "generate", new WCArgument())));
        String calcStatement = "";
        calcStatement = type.equals("double") ? "minimum + randomNumber * (max - minimum)" : "(" + type + ") (minimum + randomNumber * (max - minimum))";
        process.addStatement(this.util.exSubstitute(this.util.exDeclaration(type, "result"), calcStatement));
        methodBody.addStatement(process);
        WCBlock postprocess = new WCBlock();
        postprocess.addStatement("return result");
        methodBody.addStatement(postprocess);
        return methodBody;
    }

    private WCMethodBlock createGenerateElectedNumberBody() {
        WCMethodBlock methodBody = new WCMethodBlock();
        WCBlock preprocess = this.createGenerateElectedNumberPreprocess();
        methodBody.addStatement(preprocess);
        WCForLoop loop = new WCForLoop("number");
        loop.setComment(WCCodeGeneratorConstants.COMMENT_GENERATE_ELECTED_NUMBER);
        loop.addStatement(this.util.exSubstitute("electedNumbers[i]", this.util.exInvokeMethod("generator", "generate", new WCArgument("max"))));
        methodBody.addStatement(loop);
        WCBlock postprocess = new WCBlock();
        postprocess.addStatement("return electedNumbers");
        methodBody.addStatement(postprocess);
        return methodBody;
    }

    private WCMethodBlock createGenerateElectedNumberExcludedBody() {
        WCMethodBlock methodBody = new WCMethodBlock();
        WCBlock preprocess = this.createGenerateElectedNumberPreprocess();
        methodBody.addStatement(preprocess);
        WCForLoop loop = new WCForLoop("number");
        loop.setComment(WCCodeGeneratorConstants.COMMENT_GENERATE_ELECTED_NUMBER);
        loop.addStatement("int generatedNumber");
        loop.addStatement("if(excludedNumber>=0){" + this.util.exSubstitute("generatedNumber", this.util.exInvokeMethod("generator", "generate", new WCArgument("max-1"))));
        WCBlock exclude = new WCBlock();
        exclude.setComment(WCCodeGeneratorConstants.COMMENT_EXCLUDE);
        exclude.addStatement("if(generatedNumber >= excludedNumber){generatedNumber++;}");
        loop.addStatement(exclude);
        loop.addStatement("}else{" + this.util.exSubstitute("generatedNumber", this.util.exInvokeMethod("generator", "generate", new WCArgument("max"))) + ";}");
        loop.addStatement("if (isElectedNumber(electedNumbers, generatedNumber)) {i--;continue;} else {electedNumbers[i] = generatedNumber;}");
        methodBody.addStatement(loop);
        WCBlock postprocess = new WCBlock();
        postprocess.addStatement("return electedNumbers");
        methodBody.addStatement(postprocess);
        return methodBody;
    }

    private WCBlock createGenerateElectedNumberPreprocess() {
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement("assert(number < max)");
        String generatorLeft = this.util.exDeclaration(this.generatorClassName, "generator");
        String generatorRight = this.util.exInvokeMethod("super", "getRandomNumberGenerator", new WCArgument("generatorName"));
        preprocess.addStatement(this.util.exSubstitute(generatorLeft, generatorRight));
        String numbersLeft = this.util.exDeclaration("int[]", "electedNumbers");
        String numbersRight = "new int[number]";
        preprocess.addStatement(this.util.exSubstitute(numbersLeft, numbersRight));
        preprocess.addStatement(this.util.exInvokeMethod("Arrays", "fill", new WCArgument("electedNumbers,-1")));
        return preprocess;
    }

    private WCMethodBlock createIsElectedBody() {
        WCMethodBlock methodBody = new WCMethodBlock();
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement("int[] copy = new int[electedNumbers.length];for (int i = 0; i < copy.length; i++) {copy[i] = electedNumbers[i];}" + WCCodeGeneratorConstants.CR + WCCodeGeneratorConstants.CR);
        methodBody.addStatement(preprocess);
        WCBlock process = new WCBlock();
        process.addStatement(this.util.exInvokeMethod(this.arraysClassName, "sort", new WCArgument("copy")));
        String left = this.util.exDeclaration("int", "result");
        String right = this.util.exInvokeMethod(this.arraysClassName, "binarySearch", new WCArgument("copy,target"));
        process.addStatement(this.util.exSubstitute(left, right));
        methodBody.addStatement(process);
        WCBlock postprocess = new WCBlock();
        postprocess.addStatement("return result>=0");
        methodBody.addStatement(postprocess);
        return methodBody;
    }

    public IDOMType createType(String name) {
        IDOMType rootClass = this.domFactory.createClass();
        rootClass.setFlags(1);
        rootClass.setName(name);
        WCJavadoc javadoc = new WCJavadoc();
        javadoc.addStatement(name);
        rootClass.setComment(javadoc.toString());
        rootClass.setSuperclass(this.generator.getClassName(WorldComposerPlugin.FQCN_WORLD));
        rootClass.setFlags(1);
        return rootClass;
    }

    private IDOMField createConstant(String type, String name, String defaultValue, int flag) {
        return this.createField(type, name, defaultValue, flag | 8 | 0x10);
    }

    private IDOMField createField(String type, String name, String defaultValue, int flag) {
        IDOMField constant = this.domFactory.createField();
        constant.setFlags(flag);
        constant.setType(type);
        constant.setName(name);
        constant.setInitializer(defaultValue);
        return constant;
    }

    private IDOMMethod mainMethod() {
        IDOMMethod method = this.domFactory.createMethod();
        method.setFlags(9);
        method.setName("main");
        method.setParameters(new String[]{"String[]"}, new String[]{"args"});
        method.setComment(WCCodeGeneratorConstants.CR);
        return method;
    }

    public WCWorldTemplate getWorldTemplate() {
        return this.generator.getDocument().getWorldTemplate();
    }

    private String createGetValueStatement(WCValuedExpression value) {
        String statement;
        if (value instanceof WCRandomNumberValue) {
            String method = "";
            WCRandomNumberValue random = (WCRandomNumberValue)value;
            if (random.getType().equals("int")) {
                method = WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_INT;
            } else if (random.getType().equals("double")) {
                method = WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_DOUBLE;
            } else if (random.getType().equals("long")) {
                method = WCCodeGeneratorConstants.METHOD_NAME_GENERATE_RANDOM_LONG;
            }
            String generatorName = "";
            if (random.getGeneratorSetting().getName().equals("defaultRandom")) {
                String constants = this.generator.getClassName(CBPlugin.FQCN_FMFW_CONSTANTS);
                generatorName = String.valueOf(constants) + ".RANDOM_DEFAULT";
            } else {
                generatorName = this.generator.getNameMapper().getName(random.getGeneratorSetting());
            }
            statement = String.valueOf(method) + "(" + generatorName + "," + this.generator.getNameMapper().getName(random.getMinimum()) + "," + this.generator.getNameMapper().getName(random.getMax()) + ")";
        } else {
            statement = this.generator.getNameMapper().getName(value);
        }
        return statement;
    }

    private WCArgument createInformationArgument(WCInformationSetting setting, String agentVariableName) {
        IType type = setting.getInformationImpl();
        String modelName = this.generator.getClassName(setting.getType().getModelFQCN());
        String implName = this.generator.getClassName(type.getFullyQualifiedName());
        WCArgument argument = new WCArgument(String.valueOf(modelName) + "." + setting.getType().getTypeName());
        try {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor()) {
                    if (methods[i].getParameterTypes().length <= 0) break;
                    String factoryName = WCCodeGeneratorConstants.getInformationFactoryName(implName, agentVariableName);
                    this.generator.addInformationFactory(factoryName, implName);
                    argument.addStatement(this.util.exInvokeMethod("this", factoryName, new WCArgument(agentVariableName)));
                    return argument;
                }
                ++i;
            }
            argument.addStatement(this.util.exNewInstance(implName, new WCArgument()));
            return argument;
        }
        catch (JavaModelException e) {
            logger.warn((Object)("search information constructor failed" + type), (Throwable)e);
            return null;
        }
    }

    public IDOMImport createImport() {
        return this.domFactory.createImport();
    }

    public IDOMCompilationUnit createCompilationUnit(String oldContents, String name) {
        return this.domFactory.createCompilationUnit(oldContents, name);
    }
}

