/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boxed_economy.componentbuilder.util.ObjectCombo;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCBehaviorSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCDialog;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCGoodsSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCInformationSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTypeCombo;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WCAgentGroupDialog
extends WCDialog {
    private WCAgentGroup editingAgentGroup;
    private List editedBehaviorSettings = new ArrayList();
    private Map editedGoodsSettings = new HashMap();
    private Map editedInformationSettings = new HashMap();
    private Text nameText;
    private ObjectCombo typeCombo;
    private WCSettingTableEditor behaviorTableEditor;
    private WCSettingTableEditor goodsTableEditor;
    private WCSettingTableEditor informationTableEditor;

    public WCAgentGroupDialog(Shell parentShell, WCDocument document, WCAgentGroup agentGroup) {
        super(parentShell, document);
        super.setDialogTitle("Agent Group");
        this.editingAgentGroup = agentGroup;
    }

    protected void initializeComposite(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.initializeNameComposite(parent);
        this.initializeTypeComposite(parent);
        this.initializeSettingComposite(parent);
        parent.pack();
    }

    private void initializeNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setLayoutData((Object)new GridData(768));
        nameComposite.setLayout((Layout)new RowLayout(256));
        Label nameLabel = new Label(nameComposite, 0x1000000);
        nameLabel.setLayoutData((Object)new RowData(100, -1));
        nameLabel.setText("Name:");
        this.nameText = new Text(nameComposite, 2048);
        this.nameText.setLayoutData((Object)new RowData(205, -1));
        this.nameText.setText(this.editingAgentGroup.getName());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCAgentGroupDialog.this.nameTextChanged(e);
            }
        });
    }

    private void initializeTypeComposite(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayoutData((Object)new GridData(768));
        typeComposite.setLayout((Layout)new RowLayout(256));
        Label typeLabel = new Label(typeComposite, 0x1000000);
        typeLabel.setLayoutData((Object)new RowData(100, -1));
        typeLabel.setText("AgentType:");
        this.typeCombo = new WCTypeCombo(typeComposite, 4);
        this.typeCombo.setLayoutData(new RowData(190, -1));
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCAgentGroupDialog.this.typeSelected(e);
            }
        });
        this.typeCombo.setObjects(this.getDocument().getProject().getAgentTypes());
        this.typeCombo.select(this.editingAgentGroup.getType());
        this.typeCombo.redraw();
    }

    private void initializeSettingComposite(Composite parent) {
        Composite settingComposite = new Composite(parent, 0);
        settingComposite.setLayoutData((Object)new GridData(1808));
        settingComposite.setLayout((Layout)new FillLayout(512));
        this.initializeBehaviorSettingComposite(settingComposite);
        this.initializeGoodsComposite(settingComposite);
        this.initializeInformationSettingComposite(settingComposite);
    }

    private void initializeBehaviorSettingComposite(Composite settingComposite) {
        Composite behaviorComposite = new Composite(settingComposite, 0);
        behaviorComposite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(behaviorComposite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Behavior");
        this.behaviorTableEditor = new WCBehaviorSettingTableEditor(this.getDocument(), this.editingAgentGroup);
        this.behaviorTableEditor.createControl(behaviorComposite);
    }

    private void initializeGoodsComposite(Composite settingComposite) {
        Composite goodsComposite = new Composite(settingComposite, 0);
        goodsComposite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(goodsComposite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Goods");
        this.goodsTableEditor = new WCGoodsSettingTableEditor(this.getDocument(), this.editingAgentGroup);
        this.goodsTableEditor.createControl(goodsComposite);
    }

    private void initializeInformationSettingComposite(Composite settingComposite) {
        Composite informationComposite = new Composite(settingComposite, 0);
        informationComposite.setLayout((Layout)new GridLayout(1, true));
        Label label = new Label(informationComposite, 0);
        label.setLayoutData((Object)new GridData(768));
        label.setText("Information");
        this.informationTableEditor = new WCInformationSettingTableEditor(this.getDocument(), this.editingAgentGroup);
        this.informationTableEditor.createControl(informationComposite);
    }

    public WCAgentGroup getAgentGroup() {
        return this.editingAgentGroup;
    }

    protected int getHeight() {
        return 600;
    }

    protected int getWidth() {
        return 800;
    }

    protected void okPressed() {
        this.getDocument().setName(this.editingAgentGroup, this.nameText.getText());
        this.getDocument().setType(this.editingAgentGroup, (WCTypeModel)this.typeCombo.getSelectionObject());
        this.behaviorTableEditor.performFinish();
        this.goodsTableEditor.performFinish();
        this.informationTableEditor.performFinish();
        super.okPressed();
    }

    protected void nameTextChanged(ModifyEvent e) {
        this.stateChanged();
    }

    protected void typeSelected(SelectionEvent e) {
        this.stateChanged();
    }

    public void stateChanged() {
        if (this.nameText.getText().equals("")) {
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }
}

