/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCBehaviorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableItem;

public class WCBehaviorSettingTableEditor
extends WCSettingTableEditor {
    public static final String[] BEHAVIOR_COLUMN_NAMES = new String[]{"BehaviorType"};
    public static final int[] BEHAVIOR_COLUMN_WIDTH = new int[]{775};
    private Set editedBehaviorSettings;

    public WCBehaviorSettingTableEditor(WCDocument document, WCAgentGroup editingAgentGroup) {
        super(document, editingAgentGroup);
    }

    protected void initializeTableItem() {
        List behaviorTypes = this.getDocument().getProject().getBehaviorTypes();
        this.editedBehaviorSettings = new TreeSet();
        Iterator i = behaviorTypes.iterator();
        while (i.hasNext()) {
            WCTypeModel behaviorType = (WCTypeModel)i.next();
            WCBehaviorSetting setting = new WCBehaviorSetting(behaviorType, this.getDocument());
            TableItem item = new TableItem(this.getTableViewer().getTable(), 0);
            item.setData((Object)setting);
            item.setText(behaviorType.toString());
            this.editedBehaviorSettings.add(setting);
        }
    }

    protected void updateTable() {
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int index = 0;
        while (index < items.length) {
            WCBehaviorSetting defaultBehaviorSetting = (WCBehaviorSetting)items[index].getData();
            List behaviorSettings = this.getEditingAgentGroup().getBehaviorSettings();
            Iterator i = behaviorSettings.iterator();
            while (i.hasNext()) {
                WCBehaviorSetting behaviorSetting = (WCBehaviorSetting)i.next();
                WCTypeModel hadType = behaviorSetting.getType();
                if (!defaultBehaviorSetting.getType().equals(hadType)) continue;
                items[index].setChecked(true);
                items[index].setData((Object)behaviorSetting);
                this.editedBehaviorSettings.add(behaviorSetting);
            }
            ++index;
        }
    }

    public void performFinish() {
        ArrayList<WCBehaviorSetting> behaviorSettings = new ArrayList<WCBehaviorSetting>();
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                WCBehaviorSetting setting = (WCBehaviorSetting)items[i].getData();
                behaviorSettings.add(setting);
            }
            ++i;
        }
        this.getDocument().setBehaviorSettings(this.getEditingAgentGroup(), behaviorSettings);
    }

    protected void tableSelected(SelectionEvent e) {
        super.tableSelected(e);
        TableItem item = (TableItem)e.item;
        if (item.getChecked()) {
            this.editedBehaviorSettings.add(e.item.getData());
        } else {
            this.editedBehaviorSettings.remove(e.item.getData());
        }
    }

    protected Object getElements() {
        return this.editedBehaviorSettings;
    }

    protected String getTitle() {
        return "Behavior";
    }

    protected String[] getColumnNames() {
        return BEHAVIOR_COLUMN_NAMES;
    }

    protected int[] getColumnWidth() {
        return BEHAVIOR_COLUMN_WIDTH;
    }

    protected CellEditor[] getCellEditors() {
        return new CellEditor[BEHAVIOR_COLUMN_NAMES.length];
    }

    protected ICellModifier getCellModifiers() {
        return null;
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCBehaviorSettingTableEditor.this.editedBehaviorSettings.toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new BehaviorSettingLabelProvider();
    }

    class BehaviorSettingLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        BehaviorSettingLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCBehaviorSetting behaviorSetting = (WCBehaviorSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = behaviorSetting.getType().toString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

