/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCSettingTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCValuedExpressionDialogCellEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCGoodsSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValueFactory;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCGoodsSettingTableEditor
extends WCSettingTableEditor {
    public static final String COLUMN_GOODS_TYPE = "GoodsType";
    public static final String COLUMN_QUANTITY = "Quantity";
    public static final String[] GOODS_COLUMN_NAMES = new String[]{"GoodsType", "Quantity"};
    public static final int[] GOODS_COLUMN_WIDTH = new int[]{395, 380};
    private Map editingGoodsSettings;

    public WCGoodsSettingTableEditor(WCDocument document, WCAgentGroup editingAgentGroup) {
        super(document, editingAgentGroup);
    }

    protected void initializeTableItem() {
        List goodsTypes = this.getDocument().getProject().getGoodsTypes();
        this.editingGoodsSettings = new TreeMap();
        Iterator i = goodsTypes.iterator();
        while (i.hasNext()) {
            WCTypeModel goodsType = (WCTypeModel)i.next();
            WCValue value = WCValueFactory.createValue("int", "0");
            this.editingGoodsSettings.put(new WCGoodsSetting(goodsType, this.getDocument(), value), value);
        }
        this.getTableViewer().setInput((Object)this.editingGoodsSettings);
    }

    protected void updateTable() {
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int index = 0;
        while (index < items.length) {
            WCGoodsSetting defalutSetting = (WCGoodsSetting)items[index].getData();
            List goodsSettings = this.getEditingAgentGroup().getGoodsSettings();
            Iterator i = goodsSettings.iterator();
            while (i.hasNext()) {
                WCGoodsSetting goodsSetting = (WCGoodsSetting)i.next();
                WCTypeModel hadType = goodsSetting.getType();
                if (!hadType.toString().equals(defalutSetting.getType().toString())) continue;
                items[index].setChecked(true);
                this.editingGoodsSettings.put(goodsSetting, goodsSetting.getQuantity());
            }
            ++index;
        }
        this.getTableViewer().refresh();
    }

    public void performFinish() {
        ArrayList<WCGoodsSetting> goodsSettings = new ArrayList<WCGoodsSetting>();
        TableItem[] items = this.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getChecked()) {
                WCGoodsSetting setting = (WCGoodsSetting)items[i].getData();
                goodsSettings.add(setting);
                this.getDocument().setQuantity(setting, (WCValuedExpression)this.editingGoodsSettings.get(setting));
            }
            ++i;
        }
        this.getDocument().setGoodsSettings(this.getEditingAgentGroup(), goodsSettings);
    }

    protected Object getElements() {
        return this.editingGoodsSettings;
    }

    protected String getTitle() {
        return "Behavior";
    }

    protected String[] getColumnNames() {
        return GOODS_COLUMN_NAMES;
    }

    protected int[] getColumnWidth() {
        return GOODS_COLUMN_WIDTH;
    }

    protected CellEditor[] getCellEditors() {
        Table table = this.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[GOODS_COLUMN_NAMES.length];
        editors[0] = null;
        editors[1] = new WCValuedExpressionDialogCellEditor(table, 0, this.getDocument());
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new GoodsSettingCellModifier(this.getTableViewer().getTable());
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCGoodsSettingTableEditor.this.editingGoodsSettings.keySet().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new GoodsLabelProvider();
    }

    class GoodsSettingCellModifier
    implements ICellModifier {
        Table table;

        public GoodsSettingCellModifier(Table table) {
            this.table = table;
        }

        public boolean canModify(Object element, String property) {
            return !property.equals(WCGoodsSettingTableEditor.COLUMN_GOODS_TYPE);
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(GOODS_COLUMN_NAMES);
            int columnIndex = columnNames.indexOf(property);
            String result = null;
            WCGoodsSetting goodsSetting = (WCGoodsSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = goodsSetting.getType().toString();
                    break;
                }
                case 1: {
                    result = WCGoodsSettingTableEditor.this.editingGoodsSettings.get(goodsSetting);
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(GOODS_COLUMN_NAMES);
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCGoodsSetting goodsSetting = (WCGoodsSetting)item.getData();
            switch (columnIndex) {
                case 0: {
                    break;
                }
                case 1: {
                    WCValuedExpression valueObject = (WCValuedExpression)WCGoodsSettingTableEditor.this.getTableViewer().getCellEditors()[1].getValue();
                    WCGoodsSettingTableEditor.this.editingGoodsSettings.put(goodsSetting, valueObject);
                    item.setChecked(true);
                    break;
                }
                default: {
                    return;
                }
            }
            WCGoodsSettingTableEditor.this.getTableViewer().update((Object)goodsSetting, null);
        }
    }

    class GoodsLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        GoodsLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCGoodsSetting goodsSetting = (WCGoodsSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = goodsSetting.getType().toString();
                    break;
                }
                case 1: {
                    result = ((WCValuedExpression)WCGoodsSettingTableEditor.this.editingGoodsSettings.get(goodsSetting)).getValueAsString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

