/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerException;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCAgentGroupTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCParameterTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRandomNumberGeneraorTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRelationGroupTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WorldComposer;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCClockSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCWorldTemplate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sdeditor.util.ProgressMonitorDialogWithTitle;

public class WCMainComposite {
    private WCDocument document;
    private WorldComposer editor;
    private ScrolledComposite mainComposite;
    private Text nameText;
    private Text descriptionText;
    private Button generateButton;
    private Button loadModelButton;

    public WCMainComposite(WCDocument document, WorldComposer editor) {
        this.document = document;
        this.editor = editor;
    }

    public void createControl(Composite parent) {
        this.mainComposite = new ScrolledComposite(parent, 768);
        this.mainComposite.setLayout((Layout)new RowLayout());
        this.mainComposite.setAlwaysShowScrollBars(true);
        this.mainComposite.getVerticalBar().setIncrement(7);
        Composite main = new Composite((Composite)this.mainComposite, 0);
        this.mainComposite.setContent((Control)main);
        main.setLayout((Layout)new RowLayout(512));
        this.intitializeLoadModelButton(main);
        this.initializeWorldSettingGroup(main);
        this.initializeParameterGroup(main);
        this.initializeAgentGroupGroup(main);
        this.initializeRelationGroupGroup(main);
        this.initializeButtons(main);
        main.pack();
    }

    private void intitializeLoadModelButton(Composite main) {
        Composite buttonComposite = new Composite(main, 0);
        buttonComposite.setLayoutData((Object)new RowData(500, 40));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.loadModelButton = new Button(buttonComposite, 8);
        this.loadModelButton.setLayoutData((Object)new GridData(640));
        this.loadModelButton.setText("Load Model");
        this.loadModelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCMainComposite.this.loadModelPushed(e);
            }
        });
    }

    private void initializeWorldSettingGroup(Composite parent) {
        Group nameGroup = new Group(parent, 0);
        nameGroup.setText("World Setting");
        nameGroup.setLayout((Layout)new GridLayout());
        nameGroup.setLayoutData((Object)new RowData(500, 350));
        this.initializeWorldNameComposite((Composite)nameGroup);
        this.initializeWorldDescriptionComposite((Composite)nameGroup);
        this.initializeClockSettingComposite(nameGroup);
        this.initializeRandomNumberGeneratorSettingComposite((Composite)nameGroup);
        nameGroup.pack();
    }

    private void initializeParameterGroup(Composite parent) {
        Group parameterGroup = new Group(parent, 0);
        parameterGroup.setText("World Parameter");
        parameterGroup.setLayoutData((Object)new RowData(500, 200));
        parameterGroup.setLayout((Layout)new GridLayout(1, true));
        WCParameterTableEditComposite composite = new WCParameterTableEditComposite((Composite)parameterGroup, 0, this.document);
        composite.setLayoutData(new GridData(1808));
    }

    private void initializeAgentGroupGroup(Composite parent) {
        Group agentGroupGroup = new Group(parent, 0);
        agentGroupGroup.setText("Agent Group");
        agentGroupGroup.setLayoutData((Object)new RowData(500, 200));
        agentGroupGroup.setLayout((Layout)new GridLayout(1, true));
        WCAgentGroupTableEditComposite composite = new WCAgentGroupTableEditComposite((Composite)agentGroupGroup, 0, this.document);
        composite.setLayoutData(new GridData(1808));
    }

    private void initializeRelationGroupGroup(Composite parent) {
        Group relationGroupGroup = new Group(parent, 0);
        relationGroupGroup.setText("Relation Group");
        relationGroupGroup.setLayoutData((Object)new RowData(500, 200));
        relationGroupGroup.setLayout((Layout)new GridLayout(1, true));
        WCRelationGroupTableEditComposite composite = new WCRelationGroupTableEditComposite((Composite)relationGroupGroup, 0, this.document);
        composite.setLayoutData(new GridData(1808));
    }

    private void initializeButtons(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new RowData(500, 40));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.generateButton = new Button(buttonComposite, 8);
        this.generateButton.setLayoutData((Object)new GridData(640));
        this.generateButton.setText("Generate World");
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCMainComposite.this.generatePushed(e);
            }
        });
        this.updateGenerateButtonState();
    }

    private void initializeWorldNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setSize(500, 500);
        nameComposite.setLayout((Layout)new RowLayout());
        nameComposite.setLayoutData((Object)new GridData(768));
        Label nameLabel = new Label(nameComposite, 0);
        nameLabel.setText("World Name:");
        Label worldLabel = new Label(nameComposite, 0);
        worldLabel.setText(this.getWorldTemplate().getName());
    }

    private void initializeWorldDescriptionComposite(Composite parent) {
        Composite descriptionComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 3;
        descriptionComposite.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 40;
        descriptionComposite.setLayoutData((Object)gridData);
        Label descriptionLabel = new Label(descriptionComposite, 0);
        descriptionLabel.setText("World Description:");
        this.descriptionText = new Text(descriptionComposite, 2818);
        this.descriptionText.setLayoutData((Object)new GridData(1808));
        this.descriptionText.setText(this.getWorldTemplate().getDescription());
        this.descriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCMainComposite.this.worldDescriptionChanged(e);
            }
        });
    }

    private void initializeClockSettingComposite(Group parent) {
        Composite clockSettingComposite = new Composite((Composite)parent, 0);
        GridLayout layout = new GridLayout(3, true);
        layout.marginWidth = 3;
        clockSettingComposite.setLayout((Layout)layout);
        clockSettingComposite.setLayoutData((Object)new GridData(768));
        Label clockLabel = new Label(clockSettingComposite, 0);
        clockLabel.setText("Clock Setting:");
        Button stepRadio = new Button(clockSettingComposite, 16);
        stepRadio.setText("Step Clock");
        stepRadio.setLayoutData((Object)new GridData(768));
        stepRadio.setData((Object)WCClockSetting.STEP_CLOCK);
        stepRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCMainComposite.this.clockChanged(e);
            }
        });
        Button realRadio = new Button(clockSettingComposite, 16);
        realRadio.setText("Real Clock");
        realRadio.setData((Object)WCClockSetting.REAL_CLOCK);
        realRadio.setLayoutData((Object)new GridData(768));
        realRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCMainComposite.this.clockChanged(e);
            }
        });
        if (this.getWorldTemplate().getClockSetting().toString().equals(WCClockSetting.STEP_CLOCK.toString())) {
            stepRadio.setSelection(true);
        } else {
            realRadio.setSelection(true);
        }
    }

    private void initializeRandomNumberGeneratorSettingComposite(Composite parent) {
        Composite randomSettingComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 3;
        randomSettingComposite.setLayout((Layout)layout);
        Label clockLabel = new Label(randomSettingComposite, 0);
        clockLabel.setText("Random Number Generator Setting:");
        WCRandomNumberGeneraorTableEditComposite composite = new WCRandomNumberGeneraorTableEditComposite(parent, 0, this.document);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 50;
        composite.setLayoutData(gridData);
    }

    protected void worldNameChanged(ModifyEvent e) {
        String name = this.nameText.getText();
        if (name != null && !name.equals("")) {
            this.document.setWorldName(this.nameText.getText());
        }
        this.updateGenerateButtonState();
    }

    protected void worldDescriptionChanged(ModifyEvent e) {
        String description = this.descriptionText.getText();
        if (description != null && !description.equals("")) {
            this.document.setWorldDescription(this.descriptionText.getText());
        }
    }

    protected void clockChanged(SelectionEvent e) {
        Button button = (Button)e.getSource();
        if (button.getSelection()) {
            this.document.setClockSetting((WCClockSetting)button.getData());
        }
    }

    protected void generatePushed(SelectionEvent e) {
        try {
            ProgressMonitorDialogWithTitle dialog = new ProgressMonitorDialogWithTitle(this.mainComposite.getShell(), "Generate World");
            dialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        WCMainComposite.this.document.getCodeGenerator(WCMainComposite.this.editor.getFile()).generate(monitor);
                    }
                    catch (Exception ex) {
                        throw new WorldComposerException("exception in generate code logic", ex);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new WorldComposerException("exception in generate code process", ex);
        }
    }

    protected void loadModelPushed(SelectionEvent e) {
        this.document.getProject().initialize();
    }

    private void updateGenerateButtonState() {
    }

    private WCWorldTemplate getWorldTemplate() {
        return this.document.getWorldTemplate();
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }
}

