/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.Arrays;
import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCOrderChangeTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValueFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCParameterTableEditor
extends WCOrderChangeTableEditor {
    public WCParameterTableEditor(WCDocument document, WCTableEditComposite composite) {
        super(document, composite);
    }

    protected Object getElements() {
        return this.getDocument().getWorldTemplate().getParameters();
    }

    protected void updateTable() {
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Type", "Description", "Value"};
    }

    protected int[] getColumnWidth() {
        return new int[]{110, 50, 190, 100};
    }

    protected CellEditor[] getCellEditors() {
        Table table = super.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.getColumnNames().length];
        editors[0] = new TextCellEditor((Composite)table);
        editors[1] = new ComboBoxCellEditor((Composite)table, WCValueFactory.getKeys(), 12);
        editors[2] = new TextCellEditor((Composite)table);
        editors[3] = new TextCellEditor((Composite)table);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new ParameterCellModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCParameterTableEditor.this.getDocument().getWorldTemplate().getParameters().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new ParameterLabelProvider();
    }

    class ParameterCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(WCParameterTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            Object result = null;
            WCParameter parameter = (WCParameter)element;
            switch (columnIndex) {
                case 0: {
                    result = parameter.getName();
                    break;
                }
                case 1: {
                    String stringValue = parameter.getType();
                    List<String> choices = Arrays.asList(WCValueFactory.getKeys());
                    int index = choices.indexOf(stringValue);
                    result = new Integer(index);
                    break;
                }
                case 2: {
                    result = parameter.getDescription();
                    break;
                }
                case 3: {
                    result = ((WCValue)parameter.getValue()).getValueAsString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(WCParameterTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCParameter parameter = (WCParameter)item.getData();
            switch (columnIndex) {
                case 0: {
                    if (value.toString().equals("")) {
                        StatusInfo status = new StatusInfo(4, "The name is blank. Input name.");
                        ErrorDialog.openError((Shell)WCParameterTableEditor.this.getTableViewer().getTable().getShell(), (String)"Error", (String)"Can not modify parameter. ", (IStatus)status);
                        break;
                    }
                    WCParameterTableEditor.this.getDocument().setName(parameter, value.toString());
                    break;
                }
                case 1: {
                    String valueString = WCValueFactory.getKeys()[(Integer)value].trim();
                    WCParameterTableEditor.this.getDocument().setType(parameter, valueString);
                    break;
                }
                case 2: {
                    WCParameterTableEditor.this.getDocument().setDescription(parameter, value.toString());
                    break;
                }
                case 3: {
                    WCValue valueObject = WCValueFactory.createValue(parameter.getType(), (String)value);
                    WCParameterTableEditor.this.getDocument().setValue(parameter, valueObject);
                    break;
                }
                default: {
                    return;
                }
            }
            WCParameterTableEditor.this.getTableViewer().update((Object)parameter, null);
        }
    }

    class ParameterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ParameterLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCParameter parameter = (WCParameter)element;
            switch (columnIndex) {
                case 0: {
                    result = parameter.getName();
                    break;
                }
                case 1: {
                    result = parameter.getType();
                    break;
                }
                case 2: {
                    result = parameter.getDescription();
                    break;
                }
                case 3: {
                    result = ((WCValue)parameter.getValue()).getValueAsString();
                    break;
                }
            }
            return result;
        }
    }
}

