/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCElementTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCLongValue;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCRandomNumberGeneratorTableEditor
extends WCElementTableEditor {
    private Map generatorImplMap = new HashMap();

    public WCRandomNumberGeneratorTableEditor(WCDocument document) {
        super(document);
    }

    protected Object getElements() {
        return this.getDocument().getWorldTemplate().getRandomNumberGeneratorSettings();
    }

    protected void updateTable() {
    }

    protected String[] getColumnNames() {
        return new String[]{"GeneratorClass", "Name", "Seed"};
    }

    protected int[] getColumnWidth() {
        return new int[]{240, 120, 90};
    }

    protected CellEditor[] getCellEditors() {
        Table table = super.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.getColumnNames().length];
        editors[0] = new ComboBoxCellEditor((Composite)table, this.getRandomNumberGeneretorNames(), 12);
        editors[1] = new TextCellEditor((Composite)table);
        editors[2] = new TextCellEditor((Composite)table);
        return editors;
    }

    protected ICellModifier getCellModifiers() {
        return new RandomNumberGeneratorCellModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCRandomNumberGeneratorTableEditor.this.getDocument().getWorldTemplate().getRandomNumberGeneratorSettings().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new RandomNumberGeneratorLabelProvider();
    }

    private String[] getRandomNumberGeneretorNames() {
        List generators = this.getDocument().getProject().getRandomNumberGeneratorTypes();
        Object[] names = new String[generators.size()];
        int i = 0;
        while (i < generators.size()) {
            IType generator = (IType)generators.get(i);
            names[i] = generator.getElementName();
            if (this.generatorImplMap == null) {
                this.generatorImplMap = new HashMap();
            }
            this.generatorImplMap.put(names[i], generator);
            ++i;
        }
        Arrays.sort(names);
        return names;
    }

    protected void tableSelected(SelectionEvent e) {
        if (this.getTableViewer().getTable().isSelected(0)) {
            this.getTableViewer().getTable().deselect(0);
        }
    }

    class RandomNumberGeneratorCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return WCRandomNumberGeneratorTableEditor.this.getTableViewer().getTable().getSelectionIndex() > 0;
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(WCRandomNumberGeneratorTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            Object result = null;
            WCRandomNumberGeneratorSetting setting = (WCRandomNumberGeneratorSetting)element;
            switch (columnIndex) {
                case 0: {
                    String stringValue = setting.getClassName();
                    Object[] choices = WCRandomNumberGeneratorTableEditor.this.getRandomNumberGeneretorNames();
                    int index = Arrays.binarySearch(choices, stringValue);
                    result = new Integer(index);
                    break;
                }
                case 1: {
                    result = setting.getName();
                    break;
                }
                case 2: {
                    result = setting.getSeed().getValueAsString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(WCRandomNumberGeneratorTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCRandomNumberGeneratorSetting setting = (WCRandomNumberGeneratorSetting)item.getData();
            switch (columnIndex) {
                case 0: {
                    String valueString = WCRandomNumberGeneratorTableEditor.this.getRandomNumberGeneretorNames()[(Integer)value].trim();
                    IType generator = (IType)WCRandomNumberGeneratorTableEditor.this.generatorImplMap.get(valueString);
                    WCRandomNumberGeneratorTableEditor.this.getDocument().setGeneratorImpl(setting, generator.getPackageFragment().getElementName(), generator.getElementName());
                    break;
                }
                case 1: {
                    WCRandomNumberGeneratorTableEditor.this.getDocument().setName(setting, value.toString());
                    break;
                }
                case 2: {
                    WCLongValue seed = new WCLongValue(Long.parseLong(value.toString()));
                    WCRandomNumberGeneratorTableEditor.this.getDocument().setSeed(setting, seed);
                    break;
                }
                default: {
                    return;
                }
            }
            WCRandomNumberGeneratorTableEditor.this.getTableViewer().update((Object)setting, null);
        }
    }

    class RandomNumberGeneratorLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RandomNumberGeneratorLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCRandomNumberGeneratorSetting generator = (WCRandomNumberGeneratorSetting)element;
            switch (columnIndex) {
                case 0: {
                    result = generator.getClassName();
                    break;
                }
                case 1: {
                    result = generator.getName();
                    break;
                }
                case 2: {
                    result = generator.getSeed().getValueAsString();
                    break;
                }
            }
            return result;
        }
    }
}

