/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.CBPlugin;
import org.boxed_economy.componentbuilder.util.ObjectCombo;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCDialog;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCCustomComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCSelfRelationPattern;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WCRelationGroupDialog
extends WCDialog {
    private static final Logger logger;
    public static final String ONE_WAY = "one way";
    public static final String TWO_WAY = "two way";
    public static final String[] DIRECTIONS;
    private static final ImageDescriptor IMG_ONEWAY;
    private static final ImageDescriptor IMG_TWOWAY;
    private WCRelationGroup editingRelationGroup;
    private Composite parent;
    private Table sourceTable;
    private Table targetTable;
    private Text nameText;
    private ObjectCombo typeCombo;
    private Combo directionCombo;
    private Label arrowLabel;
    private ObjectCombo patternCombo;
    private WCCustomComposite relationPatternSettingComposite;
    private List editedSourceAgents = new ArrayList();
    private List editedTargetAgents = new ArrayList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.editor.WCRelationGroupDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        DIRECTIONS = new String[]{ONE_WAY, TWO_WAY};
        IMG_ONEWAY = CBPlugin.getDefault().getBannerImg("oneway.gif");
        IMG_TWOWAY = CBPlugin.getDefault().getBannerImg("twoway.gif");
    }

    public WCRelationGroupDialog(Shell parentShell, WCDocument document, WCRelationGroup relationGroup) {
        super(parentShell, document);
        super.setDialogTitle("Relation Group");
        this.editingRelationGroup = relationGroup;
        this.editedSourceAgents.addAll(relationGroup.getSourceAgentGroups());
        this.editedTargetAgents.addAll(relationGroup.getTargetAgentGroups());
    }

    protected void initializeComposite(Composite parent) {
        this.parent = parent;
        parent.setLayout((Layout)new GridLayout(3, false));
        this.initializeSourceTable(parent);
        this.initializeRelationComposite(parent);
        this.initializeTargetTable(parent);
    }

    private void initializeSourceTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(1040);
        data.widthHint = 170;
        composite.setLayoutData((Object)data);
        Label sourceLabel = new Label(composite, 0x1000000);
        sourceLabel.setText("Source Agent Group");
        sourceLabel.setLayoutData((Object)new GridData(768));
        this.sourceTable = this.createAgentGroupTable(composite);
        this.setSelectedAgentGroups(this.sourceTable, this.editingRelationGroup.getSourceAgentGroups());
    }

    private void initializeRelationComposite(Composite parent) {
        Composite center = new Composite(parent, 0);
        GridData gridData = new GridData(1808);
        center.setLayoutData((Object)gridData);
        center.setLayout((Layout)new GridLayout(1, true));
        this.initializeNameComposite(center);
        this.initializeTypeComposite(center);
        this.initializeDirectionComposite(center);
        this.initializeArrowComposite(center);
        this.initializeRelationPatternComposite(center);
        this.initializeRelationPatternCustomComposite(center);
    }

    private void initializeTargetTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData data = new GridData(1040);
        data.widthHint = 170;
        composite.setLayoutData((Object)data);
        Label targetLabel = new Label(composite, 0x1000000);
        targetLabel.setText("Target Agent Group");
        targetLabel.setLayoutData((Object)new GridData(768));
        this.targetTable = this.createAgentGroupTable(composite);
        this.setSelectedAgentGroups(this.targetTable, this.editingRelationGroup.getTargetAgentGroups());
        this.updateTargetTable();
    }

    private Table createAgentGroupTable(Composite parent) {
        Table table = this.createTable(parent);
        this.createTableItem(table);
        return table;
    }

    private void setSelectedAgentGroups(Table table, List selectedAgentGroups) {
        TableItem[] tableItems = table.getItems();
        int i = 0;
        while (i < tableItems.length) {
            if (selectedAgentGroups.contains(tableItems[i].getData())) {
                tableItems[i].setChecked(true);
            }
            ++i;
        }
    }

    private void initializeNameComposite(Composite parent) {
        Composite nameComposite = new Composite(parent, 0);
        nameComposite.setLayoutData((Object)new GridData(768));
        nameComposite.setLayout((Layout)new RowLayout(512));
        Label nameLabel = new Label(nameComposite, 16384);
        nameLabel.setLayoutData((Object)new RowData(100, -1));
        nameLabel.setText("Name:");
        this.nameText = new Text(nameComposite, 2048);
        this.nameText.setLayoutData((Object)new RowData(300, -1));
        this.nameText.setText(this.editingRelationGroup.getName());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCRelationGroupDialog.this.nameTextChanged(e);
            }
        });
    }

    private void initializeTypeComposite(Composite parent) {
        Composite typeComposite = new Composite(parent, 0);
        typeComposite.setLayoutData((Object)new GridData(768));
        typeComposite.setLayout((Layout)new RowLayout(512));
        Label typeLabel = new Label(typeComposite, 16384);
        typeLabel.setLayoutData((Object)new RowData(100, -1));
        typeLabel.setText("Relation Type:");
        this.typeCombo = new ObjectCombo(typeComposite, 12);
        this.typeCombo.setLayoutData(new RowData(285, -1));
        this.typeCombo.setObjects(this.getDocument().getProject().getRelationTypes());
        this.typeCombo.select(this.editingRelationGroup.getType());
        this.typeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCRelationGroupDialog.this.typeSelected(e);
            }
        });
        this.typeCombo.redraw();
    }

    private void initializeDirectionComposite(Composite parent) {
        Composite directionComposite = new Composite(parent, 0);
        directionComposite.setLayoutData((Object)new GridData(768));
        directionComposite.setLayout((Layout)new RowLayout(512));
        Label directionLabel = new Label(directionComposite, 16384);
        directionLabel.setLayoutData((Object)new RowData(150, -1));
        directionLabel.setText("Direction:");
        this.directionCombo = new Combo(directionComposite, 12);
        this.directionCombo.setLayoutData((Object)new RowData(285, -1));
        this.directionCombo.setItems(DIRECTIONS);
        if (this.editingRelationGroup.isTwoWay()) {
            this.directionCombo.select(1);
        } else {
            this.directionCombo.select(0);
        }
        this.directionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCRelationGroupDialog.this.directionSelected(e);
            }
        });
    }

    private void initializeArrowComposite(Composite parent) {
        Composite arrowComposite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.heightHint = 50;
        arrowComposite.setLayoutData((Object)gridData);
        arrowComposite.setLayout((Layout)new FillLayout());
        this.arrowLabel = new Label(arrowComposite, 0);
        this.updateArrow();
    }

    private void updateArrow() {
        if (this.patternCombo != null && this.patternCombo.getSelectionObject() instanceof WCSelfRelationPattern) {
            this.arrowLabel.setImage(null);
        } else if (this.directionCombo.getText().equals(ONE_WAY)) {
            this.arrowLabel.setImage(IMG_ONEWAY.createImage());
        } else if (this.directionCombo.getText().equals(TWO_WAY)) {
            this.arrowLabel.setImage(IMG_TWOWAY.createImage());
        }
    }

    private void initializeRelationPatternComposite(Composite parent) {
        Composite patternComposite = new Composite(parent, 0);
        patternComposite.setLayoutData((Object)new GridData(768));
        patternComposite.setLayout((Layout)new RowLayout(512));
        Label patternLabel = new Label(patternComposite, 16384);
        patternLabel.setLayoutData((Object)new RowData(100, -1));
        patternLabel.setText("Relation Pattern:");
        this.patternCombo = new RelationPatternCombo(patternComposite, 12);
        this.patternCombo.setLayoutData(new RowData(285, -1));
        this.patternCombo.setObjects(this.createRelationPatterns());
        this.patternCombo.select(this.editingRelationGroup.getPattern());
        this.patternCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCRelationGroupDialog.this.patternSelected(e);
            }
        });
    }

    private void initializeRelationPatternCustomComposite(Composite composite) {
        this.relationPatternSettingComposite = this.editingRelationGroup.getPattern().createCustomComposite(composite, 0, this.editedSourceAgents, this.editedTargetAgents, this.getDocument());
        this.relationPatternSettingComposite.setLayoutData(new GridData(1808));
        this.relationPatternSettingComposite.createControl();
        composite.layout();
    }

    private Table createTable(Composite parent) {
        Table table = new Table(parent, 67616);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WCRelationGroupDialog.this.tableSelected(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return table;
    }

    private void createTableItem(Table table) {
        List agentGroups = this.getDocument().getWorldTemplate().getAgentGroups();
        Iterator i = agentGroups.iterator();
        while (i.hasNext()) {
            WCAgentGroup agentGroup = (WCAgentGroup)i.next();
            TableItem item = new TableItem(table, 0);
            item.setData((Object)agentGroup);
            item.setText(agentGroup.getName());
        }
    }

    private List createRelationPatterns() {
        List relationPatternClasses = this.getDocument().getProject().getRelationPatterns();
        ArrayList<WCRelationPattern> relationPatterns = new ArrayList<WCRelationPattern>();
        Iterator i = relationPatternClasses.iterator();
        while (i.hasNext()) {
            Class clazz = (Class)i.next();
            if (clazz == this.editingRelationGroup.getPattern().getClass()) {
                relationPatterns.add(this.editingRelationGroup.getPattern());
                continue;
            }
            try {
                WCRelationPattern pattern = (WCRelationPattern)clazz.newInstance();
                relationPatterns.add(pattern);
            }
            catch (Exception e) {
                logger.warn((Object)("creation relationpattern failed:" + clazz), (Throwable)e);
            }
        }
        return relationPatterns;
    }

    public WCRelationGroup getRelationGroup() {
        return this.editingRelationGroup;
    }

    protected int getHeight() {
        return 400;
    }

    protected int getWidth() {
        return 680;
    }

    protected void tableSelected(SelectionEvent e) {
        Table selectedTable = (Table)e.getSource();
        TableItem selectedItem = (TableItem)e.item;
        WCAgentGroup selectedAgentGroup = (WCAgentGroup)selectedItem.getData();
        if (e.detail != 32) {
            selectedItem.setChecked(!selectedItem.getChecked());
        } else if (selectedTable.isSelected(selectedTable.indexOf(selectedItem))) {
            selectedItem.setChecked(!selectedItem.getChecked());
        }
        if (selectedTable == this.sourceTable) {
            if (selectedItem.getChecked()) {
                this.editedSourceAgents.add(selectedAgentGroup);
            } else {
                this.editedSourceAgents.remove(selectedAgentGroup);
            }
        }
        if (selectedTable == this.targetTable) {
            if (selectedItem.getChecked()) {
                this.editedTargetAgents.add(selectedAgentGroup);
            } else {
                this.editedTargetAgents.remove(selectedAgentGroup);
            }
        }
        this.stateChanged();
    }

    protected void nameTextChanged(ModifyEvent e) {
        this.stateChanged();
    }

    protected void typeSelected(SelectionEvent e) {
        this.stateChanged();
    }

    protected void directionSelected(SelectionEvent e) {
        this.stateChanged();
        this.updateArrow();
    }

    protected void patternSelected(SelectionEvent e) {
        WCRelationPattern pattern = (WCRelationPattern)this.patternCombo.getSelectionObject();
        this.getDocument().setPattern(this.editingRelationGroup, pattern);
        Composite parent = this.relationPatternSettingComposite.getParent();
        this.relationPatternSettingComposite.dispose();
        this.initializeRelationPatternCustomComposite(parent);
        this.updateTargetTable();
        this.updateArrow();
        this.stateChanged();
    }

    private void updateTargetTable() {
        WCRelationPattern pattern = (WCRelationPattern)this.patternCombo.getSelectionObject();
        if (pattern.isInternal()) {
            this.targetTable.setEnabled(false);
            this.targetTable.deselectAll();
            this.directionCombo.setEnabled(false);
        } else {
            this.targetTable.setEnabled(true);
            this.directionCombo.setEnabled(true);
        }
    }

    public void stateChanged() {
        WCRelationPattern pattern = (WCRelationPattern)this.patternCombo.getSelectionObject();
        if (this.nameText.getText().equals("")) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.editedSourceAgents.isEmpty()) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (this.editedTargetAgents.isEmpty() && !pattern.isInternal()) {
            this.getButton(0).setEnabled(false);
            return;
        }
        if (!this.relationPatternSettingComposite.canFinish()) {
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    protected void okPressed() {
        this.getDocument().setName(this.editingRelationGroup, this.nameText.getText());
        this.getDocument().setPattern(this.editingRelationGroup, (WCRelationPattern)this.patternCombo.getSelectionObject());
        boolean isTwoWay = this.directionCombo.getText().equals(TWO_WAY);
        this.getDocument().setTwoWay(this.editingRelationGroup, isTwoWay);
        this.getDocument().setType(this.editingRelationGroup, (WCTypeModel)this.typeCombo.getSelectionObject());
        this.getDocument().setSourceAgentGroups(this.editingRelationGroup, this.editedSourceAgents);
        this.getDocument().setTargetAgentGroups(this.editingRelationGroup, this.editedTargetAgents);
        this.relationPatternSettingComposite.performFinish();
        super.okPressed();
    }

    class RelationPatternCombo
    extends ObjectCombo {
        public RelationPatternCombo(Composite parent, int style) {
            super(parent, style);
        }

        protected String representObject(Object o) {
            return ((WCRelationPattern)o).getName();
        }
    }
}

