/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCElementTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRelationGroupDialog;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRelationGroupTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCAllRelationPattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

public class WCRelationGroupTableEditComposite
extends WCTableEditComposite {
    private WCElementTableEditor tableEditor;

    public WCRelationGroupTableEditComposite(Composite parent, int style, WCDocument document) {
        super(parent, style, document);
    }

    protected void initializeTableEditor() {
        this.tableEditor = new WCRelationGroupTableEditor(this.getDocument(), this);
    }

    protected WCElementTableEditor getTableEditor() {
        return this.tableEditor;
    }

    protected void addButtonPushed(SelectionEvent e) {
        List relationTypes = this.getDocument().getProject().getRelationTypes();
        if (relationTypes.isEmpty()) {
            StatusInfo status = new StatusInfo(4, "This project has no RelationTypes. Set classpath to Model file and reload project.");
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Can not create dialog. ", (IStatus)status);
            return;
        }
        WCTypeModel defaultType = (WCTypeModel)relationTypes.get(0);
        WCRelationGroup relationGroup = new WCRelationGroup("NewRelationGroup", defaultType, this.getDocument(), new WCAllRelationPattern(), true);
        WCRelationGroupDialog dialog = new WCRelationGroupDialog(this.getShell(), this.getDocument(), relationGroup);
        int result = dialog.open();
        if (result == 0) {
            WCRelationGroup newRelationGroup = dialog.getRelationGroup();
            this.getDocument().addRelationGroup(newRelationGroup);
            this.getTableViewer().refresh();
            this.getTableViewer().setSelection((ISelection)new StructuredSelection((Object)newRelationGroup));
            super.updateButtonsStateChanged();
        }
        this.getTableViewer().refresh();
    }

    protected void modifyButtonPushed(SelectionEvent e) {
        TableItem[] items = this.getTableViewer().getTable().getSelection();
        if (items.length == 0) {
            return;
        }
        WCRelationGroup editingRelationGroup = (WCRelationGroup)items[0].getData();
        WCRelationGroupDialog dialog = new WCRelationGroupDialog(this.getShell(), this.getDocument(), editingRelationGroup);
        dialog.open();
        this.getTableViewer().refresh();
    }

    protected void removeButtonPushed(SelectionEvent e) {
        TableItem[] selectedItems = this.getTableViewer().getTable().getSelection();
        int i = 0;
        while (i < selectedItems.length) {
            WCRelationGroup relationGroup = (WCRelationGroup)selectedItems[i].getData();
            this.getDocument().removeRelationGroup(relationGroup);
            ++i;
        }
        this.getTableViewer().refresh();
    }

    protected void moveUp(Object target) {
        this.getDocument().moveUpRelationGroup((WCRelationGroup)target);
    }

    protected void moveDown(Object target) {
        this.getDocument().moveDownRelationGroup((WCRelationGroup)target);
    }
}

