/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCOrderChangeTableEditor;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCTableEditComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class WCRelationGroupTableEditor
extends WCOrderChangeTableEditor {
    private static final Logger logger;
    private Map relationPatterns;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.editor.WCRelationGroupTableEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public WCRelationGroupTableEditor(WCDocument document, WCTableEditComposite composite) {
        super(document, composite);
    }

    protected Object getElements() {
        return this.getDocument().getWorldTemplate().getRelationGroups();
    }

    protected void updateTable() {
    }

    protected String[] getColumnNames() {
        return new String[]{"Name", "Relation Pattern", "Description"};
    }

    protected int[] getColumnWidth() {
        return new int[]{150, 130, 170};
    }

    protected CellEditor[] getCellEditors() {
        Table table = super.getTableViewer().getTable();
        CellEditor[] editors = new CellEditor[this.getColumnNames().length];
        editors[0] = new TextCellEditor((Composite)table);
        editors[1] = new ComboBoxCellEditor((Composite)table, this.getRelationPatternNames(), 12);
        editors[2] = null;
        return editors;
    }

    private String[] getRelationPatternNames() {
        if (this.relationPatterns == null) {
            this.initializeRelationPatterns();
        }
        Set relationPatternNames = this.relationPatterns.keySet();
        String[] names = new String[relationPatternNames.size()];
        Iterator i = relationPatternNames.iterator();
        int index = 0;
        while (i.hasNext()) {
            names[index] = i.next().toString();
            ++index;
        }
        return names;
    }

    protected ICellModifier getCellModifiers() {
        return new RelationGroupCellModifier();
    }

    protected IContentProvider getContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return WCRelationGroupTableEditor.this.getDocument().getWorldTemplate().getRelationGroups().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected IBaseLabelProvider getLabelProvider() {
        return new RelationGroupLabelProvider();
    }

    private void initializeRelationPatterns() {
        this.relationPatterns = new HashMap();
        List patterns = this.getDocument().getProject().getRelationPatterns();
        int i = 0;
        while (i < patterns.size()) {
            Class patternClass = (Class)patterns.get(i);
            WCRelationPattern pattern = null;
            try {
                pattern = (WCRelationPattern)patternClass.newInstance();
            }
            catch (Exception e) {
                logger.warn((Object)"initialize model pattern failed", (Throwable)e);
            }
            this.relationPatterns.put(pattern.getName(), patternClass);
            ++i;
        }
    }

    class RelationGroupCellModifier
    implements ICellModifier {
        Table table;

        public boolean canModify(Object element, String property) {
            return !property.equals("Description");
        }

        public Object getValue(Object element, String property) {
            List<String> columnNames = Arrays.asList(WCRelationGroupTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            Object result = null;
            WCRelationGroup relationGroup = (WCRelationGroup)element;
            switch (columnIndex) {
                case 0: {
                    result = relationGroup.getName();
                    break;
                }
                case 1: {
                    String stringValue = relationGroup.getPattern().getName();
                    List<String> choices = Arrays.asList(WCRelationGroupTableEditor.this.getRelationPatternNames());
                    int index = choices.indexOf(stringValue);
                    result = new Integer(index);
                    break;
                }
                case 2: {
                    result = relationGroup.toString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }

        public void modify(Object element, String property, Object value) {
            List<String> columnNames = Arrays.asList(WCRelationGroupTableEditor.this.getColumnNames());
            int columnIndex = columnNames.indexOf(property);
            TableItem item = (TableItem)element;
            WCRelationGroup relationGroup = (WCRelationGroup)item.getData();
            switch (columnIndex) {
                case 0: {
                    if (value.toString().equals("")) {
                        StatusInfo status = new StatusInfo(4, "The name is blank. Input name.");
                        ErrorDialog.openError((Shell)WCRelationGroupTableEditor.this.getTableViewer().getTable().getShell(), (String)"Error", (String)"Can not modify relation group. ", (IStatus)status);
                        break;
                    }
                    WCRelationGroupTableEditor.this.getDocument().setName(relationGroup, value.toString());
                    break;
                }
                case 1: {
                    String valueString = WCRelationGroupTableEditor.this.getRelationPatternNames()[(Integer)value].trim();
                    try {
                        Class patternClass = (Class)WCRelationGroupTableEditor.this.relationPatterns.get(valueString);
                        if (relationGroup.getPattern().getClass() == patternClass) break;
                        WCRelationPattern pattern = (WCRelationPattern)patternClass.newInstance();
                        WCRelationGroupTableEditor.this.getDocument().setPattern(relationGroup, pattern);
                    }
                    catch (Exception ex) {
                        logger.warn((Object)"initialize model pattern failed", (Throwable)ex);
                    }
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    return;
                }
            }
            WCRelationGroupTableEditor.this.getTableViewer().update((Object)relationGroup, null);
        }
    }

    class RelationGroupLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        RelationGroupLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String result = "";
            WCRelationGroup relationGroup = (WCRelationGroup)element;
            switch (columnIndex) {
                case 0: {
                    result = relationGroup.getName();
                    break;
                }
                case 1: {
                    result = relationGroup.getPattern().getName();
                    break;
                }
                case 2: {
                    result = relationGroup.toString();
                    break;
                }
                default: {
                    result = "";
                }
            }
            return result;
        }
    }
}

