/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectReader;
import jp.ac.keio.sfc.crew.io.xml.XMLObjectWriter;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.util.CBCreateFileUtil;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCMainComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCProject;
import org.boxed_economy.componentbuilder.worldcomposer.model.xml.WCXMLOutput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;

public class WorldComposer
extends EditorPart
implements PropertyChangeListener {
    private static final Logger logger;
    private WCDocument document;
    private WCMainComposite composite;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.editor.WorldComposer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setDocument(new WCDocument());
        this.setInput(input);
        this.setSite((IWorkbenchPartSite)site);
        this.setTitle(input.getName());
    }

    public void setDocument(WCDocument document) {
        if (this.document == null) {
            document.removePropertyChangeListener(this);
        }
        this.document = document;
        document.addPropertyChangeListener(this);
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        try {
            this.loadDocument(this.getFile());
            this.document.setWorldName(this.trimToClass(input.getName()));
            WCProject project = WCProject.getProject(this.getFile());
            this.document.setProject(project);
            WorldComposerPlugin.setCurrentProject(project);
        }
        catch (Exception e) {
            logger.warn((Object)"cannot load the document.", (Throwable)e);
            throw new RuntimeException("cannot load the document.", e);
        }
    }

    public void createPartControl(Composite parent) {
        this.composite = new WCMainComposite(this.document, this);
        this.composite.createControl(parent);
    }

    public void setFocus() {
        WorldComposerPlugin.setCurrentProject(this.document.getProject());
        this.composite.getMainComposite().setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.saveDocument(this.getFile(), monitor);
            this.document.setDirty(false);
        }
        catch (Exception e) {
            logger.warn((Object)"cannot save the document.", (Throwable)e);
            throw new RuntimeException("cannot save the document.", e);
        }
    }

    private void saveDocument(IFile file, IProgressMonitor monitor) throws Exception {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLObjectWriter objectOutput = new XMLObjectWriter((OutputStream)out);
            objectOutput.writeObject((Object)this.document);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            out.close();
            if (file.exists()) {
                file.setContents((InputStream)in, true, false, monitor);
            } else {
                file.create((InputStream)in, true, monitor);
            }
            in.close();
            ByteArrayOutputStream xmlOut = new ByteArrayOutputStream();
            WCXMLOutput xmlWriter = new WCXMLOutput(this.document.getWorldTemplate(), xmlOut, "Shift_JIS");
            xmlWriter.writeXml();
            IPath xmlPath = file.getParent().getProjectRelativePath().append(String.valueOf(this.document.getWorldTemplate().getName()) + ".wml");
            CBCreateFileUtil.createNewFile(this.document.getProject().getProject(), xmlPath, new ByteArrayInputStream(xmlOut.toByteArray()));
        }
        catch (Throwable th) {
            throw new Exception("Cannot Save the Document", th);
        }
        monitor.done();
    }

    private void loadDocument(IFile file) throws Exception {
        try {
            InputStream input = file.getContents(false);
            XMLObjectReader stream = new XMLObjectReader(input, this.getClass().getClassLoader());
            WCDocument document = (WCDocument)((Object)stream.readObject());
            this.setDocument(document);
            input.close();
        }
        catch (Throwable th) {
            throw new Exception("Cannot Load the Document", th);
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.document.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void gotoMarker(IMarker marker) {
        System.out.println("marker");
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "dirty") {
            this.firePropertyChange(257);
        }
    }

    public String getTitleToolTip() {
        return super.getTitleToolTip();
    }

    private String trimToClass(String string) {
        int index = string.lastIndexOf(".");
        return string.substring(0, index);
    }
}

