/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerException;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCProject;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypedModel;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCValuedExpression;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public class WCInformationSetting
extends WCTypedModel
implements Comparable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private transient IType informationImpl;
    private WCValuedExpression[] creationArguments;
    private String className;
    private String packageName;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCInformationSetting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCInformationSetting");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public WCInformationSetting(WCTypeModel type, WCDocument document, IType informationImpl) {
        super(type, document);
        this.informationImpl = informationImpl;
        if (informationImpl != null) {
            this.packageName = informationImpl.getPackageFragment().getElementName();
            this.className = informationImpl.getElementName();
        }
    }

    public List getConstructorParameterTypes() {
        try {
            IMethod[] methods = this.getInformationImpl().getMethods();
            int i = 0;
            while (i < methods.length) {
                if (methods[i].isConstructor()) {
                    return Arrays.asList(methods[i].getParameterTypes());
                }
                ++i;
            }
            return new ArrayList();
        }
        catch (Exception e) {
            logger.warn((Object)("search constructor failed." + this.informationImpl), (Throwable)e);
            return new ArrayList();
        }
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackagename() {
        return this.getInformationImpl().getPackageFragment().getElementName();
    }

    public IType getInformationImpl() {
        if (this.informationImpl == null) {
            WCProject weProject = WorldComposerPlugin.getCurrentProject();
            List informationImpls = weProject.getInformationImplTypes();
            Iterator i = informationImpls.iterator();
            while (i.hasNext()) {
                IType type = (IType)i.next();
                if (!type.getFullyQualifiedName().equals(String.valueOf(this.packageName) + "." + this.className)) continue;
                this.informationImpl = type;
                return this.informationImpl;
            }
            throw new WorldComposerException("search type failed (" + this.packageName + "." + this.className + ")" + this);
        }
        return this.informationImpl;
    }

    public String getInformationImplFQCN() {
        return this.getInformationImpl().getFullyQualifiedName();
    }

    public WCValuedExpression[] getCreationArguments() {
        return this.creationArguments;
    }

    protected void setInformationImpl(IType informationImpl) {
        this.informationImpl = informationImpl;
        this.className = informationImpl.getElementName();
        this.packageName = informationImpl.getPackageFragment().getElementName();
        this.creationArguments = null;
    }

    protected void setCreationArguments(WCValuedExpression[] creationArguments) {
        if (!$assertionsDisabled && creationArguments.length != this.getConstructorParameterTypes().size()) {
            throw new AssertionError();
        }
        this.creationArguments = creationArguments;
    }

    public boolean equals(Object o) {
        if (!(o instanceof WCInformationSetting)) {
            return false;
        }
        return this.getType().equals(((WCInformationSetting)o).getType());
    }

    public int compareTo(Object o) {
        return this.getType().compareTo(((WCInformationSetting)o).getType());
    }
}

