/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.util.JavaSearchUtil;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerException;
import org.boxed_economy.componentbuilder.worldcomposer.WorldComposerPlugin;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCFindTypeASTVisitor;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCTypeModel;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jface.operation.IRunnableWithProgress;
import sdeditor.util.ProgressMonitorDialogWithTitle;

public class WCProject {
    private static final Logger logger;
    private static Map projects;
    private IProject project = null;
    private List informationImplTypes = new ArrayList();
    private List randomNumberGeneratorTypes = new ArrayList();
    private List relationPatterns = new ArrayList();
    private Map agentTypes = new HashMap();
    private Map behaviorTypes = new HashMap();
    private Map informationTypes = new HashMap();
    private Map goodsTypes = new HashMap();
    private Map relationTypes = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
        projects = new HashMap();
    }

    public static WCProject getProject(IProject project) {
        if (!projects.containsKey(project)) {
            WCProject weProject = new WCProject();
            weProject.setProject(project);
            weProject.initialize();
            projects.put(project, weProject);
        }
        return (WCProject)projects.get(project);
    }

    public static WCProject getProject(IFile file) {
        return WCProject.getProject(file.getProject());
    }

    private WCProject() {
    }

    public void initialize() {
        try {
            this.clearAllLists();
            String title = this.getProgressMonitorTitle();
            if (title != null) {
                ProgressMonitorDialogWithTitle dialog = new ProgressMonitorDialogWithTitle(null, title);
                dialog.run(true, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        WCProject.this.initializeInternal(monitor);
                    }
                });
            } else {
                this.initializeInternal((IProgressMonitor)new NullProgressMonitor());
            }
        }
        catch (Exception ex) {
            throw new WorldComposerException("exception caught in initializing WCProject", ex);
        }
    }

    private void clearAllLists() {
        this.informationImplTypes.clear();
        this.randomNumberGeneratorTypes.clear();
        this.relationPatterns.clear();
        this.agentTypes.clear();
        this.behaviorTypes.clear();
        this.informationTypes.clear();
        this.goodsTypes.clear();
        this.relationTypes.clear();
    }

    private String getProgressMonitorTitle() {
        String title = "Initializing Boxed-Economy Project";
        String projectName = "(" + this.getProject().getName() + ")";
        return String.valueOf(title) + " " + projectName;
    }

    private void initializeInternal(IProgressMonitor monitor) {
        monitor.beginTask("", 5);
        this.startInitialize((IProgressMonitor)new SubProgressMonitor(monitor, 1));
        this.initializeTypes(new SubProgressMonitor(monitor, 1));
        this.initializeRelationPatterns(new SubProgressMonitor(monitor, 1));
        this.initializeInformationImpl(new SubProgressMonitor(monitor, 1));
        this.initializeRandomNumberGeneratorImpl(new SubProgressMonitor(monitor, 1));
        monitor.done();
    }

    private void startInitialize(IProgressMonitor monitor) {
        monitor.beginTask("", 1);
        monitor.setTaskName("Initializing Boxed-Economy Project");
        monitor.done();
    }

    private void initializeTypes(SubProgressMonitor monitor) {
        try {
            monitor.beginTask("", 2);
            List plugins = JavaSearchUtil.findSubtypes("org.boxed_economy.besp.container.BESPPlugin", false, this.getJavaProject(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
            int i = 0;
            while (i < plugins.size()) {
                IType plugin = (IType)plugins.get(i);
                if (this.isModel(plugin)) {
                    this.addTypes(plugin);
                }
                ++i;
            }
            monitor.worked(1);
        }
        catch (Exception ex) {
            logger.warn((Object)"initialize types failed.", (Throwable)ex);
        }
    }

    private void initializeRelationPatterns(SubProgressMonitor monitor) {
        try {
            monitor.beginTask("", 2);
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCAllRelationPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.relationPatterns.add(clazz);
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCRandomRelationPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.relationPatterns.add(clazz2);
            Class<?> clazz3 = class$3;
            if (clazz3 == null) {
                try {
                    clazz3 = class$3 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCSelfRelationPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.relationPatterns.add(clazz3);
            Class<?> clazz4 = class$4;
            if (clazz4 == null) {
                try {
                    clazz4 = class$4 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCCellRelationPattern");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.relationPatterns.add(clazz4);
            monitor.worked(1);
        }
        catch (Exception ex) {
            logger.warn((Object)"initialize types failed.", (Throwable)ex);
        }
    }

    private void initializeInformationImpl(SubProgressMonitor monitor) {
        try {
            this.extractClasses(monitor, this.informationImplTypes, String.valueOf(WorldComposerPlugin.FQCN_FMFW) + "." + "Information");
        }
        catch (Exception ex) {
            logger.warn((Object)"initialize information impl failed.", (Throwable)ex);
        }
    }

    private void initializeRandomNumberGeneratorImpl(SubProgressMonitor monitor) {
        try {
            this.extractClasses(monitor, this.randomNumberGeneratorTypes, String.valueOf(WorldComposerPlugin.FQCN_FMFW) + "." + "RandomNumberGenerator");
        }
        catch (Exception ex) {
            logger.warn((Object)"initialize information impl failed.", (Throwable)ex);
        }
    }

    private void addTypes(IType model) throws JavaModelException {
        ICompilationUnit unit = model.getCompilationUnit();
        CompilationUnit cunit = AST.parseCompilationUnit((ICompilationUnit)unit, (boolean)true);
        WCFindTypeASTVisitor visitor = new WCFindTypeASTVisitor();
        cunit.accept((ASTVisitor)visitor);
        Map types = visitor.getParsedTypes();
        String modelName = model.getElementName();
        String modelPackage = model.getPackageFragment().getElementName();
        Iterator i = types.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String variableName = (String)types.get(key);
            if (this.isAgentType(variableName)) {
                this.agentTypes.put(key, new WCTypeModel(modelPackage, modelName, key, variableName));
                continue;
            }
            if (this.isInformationType(variableName)) {
                this.informationTypes.put(key, new WCTypeModel(modelPackage, modelName, key, variableName));
                continue;
            }
            if (this.isRelationType(variableName)) {
                this.relationTypes.put(key, new WCTypeModel(modelPackage, modelName, key, variableName));
                continue;
            }
            if (this.isGoodsType(variableName)) {
                this.goodsTypes.put(key, new WCTypeModel(modelPackage, modelName, key, variableName));
                continue;
            }
            if (!this.isBehaviorType(variableName)) continue;
            this.behaviorTypes.put(key, new WCTypeModel(modelPackage, modelName, key, variableName));
        }
    }

    private void extractClasses(SubProgressMonitor monitor, List list, String targetFQCN) throws JavaModelException {
        monitor.beginTask("", 2);
        List classes = JavaSearchUtil.findSubtypes(targetFQCN, false, this.getJavaProject(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)monitor, 1));
        int i = 0;
        while (i < classes.size()) {
            IType type = (IType)classes.get(i);
            if (!this.isLocal(type) && type.isClass() && !Flags.isAbstract((int)type.getFlags())) {
                list.add(type);
            }
            ++i;
        }
        monitor.worked(1);
    }

    private boolean isLocal(IType type) {
        return type.getFullyQualifiedName().indexOf("$") != -1;
    }

    private boolean isModel(IType plugin) {
        String name = plugin.getElementName();
        return name.matches(".+Model");
    }

    private boolean isAbstract(Class classObject) throws JavaModelException {
        int modifier = classObject.getModifiers();
        return Modifier.isAbstract(modifier);
    }

    private boolean isBehaviorType(String field) throws JavaModelException {
        return field.indexOf("BEHAVIORTYPE") != -1;
    }

    private boolean isRelationType(String field) throws JavaModelException {
        return field.indexOf("RELATIONTYPE") != -1;
    }

    private boolean isGoodsType(String field) throws JavaModelException {
        return field.indexOf("GOODSTYPE") != -1;
    }

    private boolean isInformationType(String field) throws JavaModelException {
        return field.indexOf("INFORMATIONTYPE") != -1;
    }

    private boolean isAgentType(String field) throws JavaModelException {
        return field.indexOf("AGENTTYPE") != -1;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public IJavaProject getJavaProject() {
        IJavaProject myJavaProject = JavaCore.create((IProject)this.getProject());
        if (myJavaProject == null) {
            throw new WorldComposerException("isn't JavaProject");
        }
        return myJavaProject;
    }

    public List getAgentTypes() {
        return new ArrayList(this.agentTypes.values());
    }

    public List getBehaviorTypes() {
        return new ArrayList(this.behaviorTypes.values());
    }

    public List getGoodsTypes() {
        return new ArrayList(this.goodsTypes.values());
    }

    public List getInformationImplTypes() {
        return new ArrayList(this.informationImplTypes);
    }

    public List getInformationTypes() {
        return new ArrayList(this.informationTypes.values());
    }

    public List getRelationPatterns() {
        return new ArrayList(this.relationPatterns);
    }

    public List getRandomNumberGeneratorTypes() {
        return new ArrayList(this.randomNumberGeneratorTypes);
    }

    public List getRelationTypes() {
        return new ArrayList(this.relationTypes.values());
    }

    public WCTypeModel getTypeModel(String string) {
        HashMap types = new HashMap();
        types.putAll(this.agentTypes);
        types.putAll(this.informationTypes);
        types.putAll(this.relationTypes);
        types.putAll(this.goodsTypes);
        types.putAll(this.behaviorTypes);
        return (WCTypeModel)types.get(string);
    }
}

