/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCArgument;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCBlock;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGenerationUtil;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorConstants;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorCore;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;

public abstract class WCRelationPatternCodeGenerator {
    public static final String SOURCE_AGENT = "sourceAgent";
    public static final String TARGET_AGENT = "targetAgent";
    public static final String SOURCE_AGENTS = "sourceAgents";
    public static final String TARGET_AGENTS = "targetAgents";
    private WCRelationGroup relationGroup;
    private WCCodeGeneratorCore generator;
    private WCCodeGenerationUtil util;

    public WCRelationPatternCodeGenerator(WCRelationGroup relationGroup, WCCodeGeneratorCore generator) {
        this.relationGroup = relationGroup;
        this.generator = generator;
        this.util = new WCCodeGenerationUtil(generator);
    }

    public abstract WCBlock[] getAddRelationProcess();

    public WCRelationGroup getRelationGroup() {
        return this.relationGroup;
    }

    public WCCodeGeneratorCore getCodeGenerator() {
        return this.generator;
    }

    public WCCodeGenerationUtil getCodeGeneratorUtil() {
        return this.util;
    }

    protected void composeAgentList(WCBlock preprocess, List sourceAgents, String listName) {
        String left = this.getCodeGeneratorUtil().exDeclaration("List ", listName);
        String right = this.getCodeGeneratorUtil().exNewInstance("ArrayList", new WCArgument(WCCodeGeneratorConstants.getAgentListName(this.getCodeGenerator().getNameMapper().getName((WCAgentGroup)sourceAgents.get(0)))));
        preprocess.addStatement(this.getCodeGeneratorUtil().exSubstitute(left, right));
        int i = 1;
        while (i < sourceAgents.size()) {
            WCAgentGroup cfr_ignored_0 = (WCAgentGroup)sourceAgents.get(i);
            String addListName = WCCodeGeneratorConstants.getAgentListName(this.getCodeGenerator().getNameMapper().getName((WCAgentGroup)sourceAgents.get(i)));
            preprocess.addStatement(this.getCodeGeneratorUtil().exInvokeMethod(listName, "addAll", new WCArgument(addListName)));
            ++i;
        }
    }

    protected boolean isSingleAgent(List agents) {
        if (agents.size() > 1) {
            return false;
        }
        if (agents.isEmpty()) {
            return true;
        }
        WCAgentGroup agentGroup = (WCAgentGroup)agents.get(0);
        return agentGroup.getNumber().getValueAsString().equals("1");
    }

    protected String getTargetAgentDeclaration(String index) {
        String left = this.getCodeGeneratorUtil().exDeclaration("Agent ", TARGET_AGENT);
        String right = this.getCodeGeneratorUtil().exInvokeMethod("(Agent)targetAgents", "get", new WCArgument(index));
        return String.valueOf(this.getCodeGeneratorUtil().exSubstitute(left, right)) + WCCodeGeneratorConstants.CR;
    }

    protected String getSourceAgentDeclaration(String index) {
        String left = this.getCodeGeneratorUtil().exDeclaration("Agent ", SOURCE_AGENT);
        String right = this.getCodeGeneratorUtil().exInvokeMethod("(Agent)sourceAgents", "get", new WCArgument(index));
        return this.getCodeGeneratorUtil().exSubstitute(left, right);
    }
}

