/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCClockSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCParameter;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;

public class WCWorldTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger;
    private String name = "";
    private String description = "";
    private List randomNumberGeneratorSettings = new ArrayList();
    private WCClockSetting clockSetting = WCClockSetting.STEP_CLOCK;
    private List agentGroups = new ArrayList();
    private List relationGroups = new ArrayList();
    private List parameters = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCWorldTemplate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.boxed_economy.componentbuilder.worldcomposer.model.WCWorldTemplate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public WCWorldTemplate() {
        this.addRandomNumberGeneratorSetting(WCRandomNumberGeneratorSetting.DEFAULT_RANDOM_NUMBER_GENERATOR);
    }

    protected void addAgentGroup(WCAgentGroup template) {
        this.agentGroups.add(template);
    }

    protected void removeAgentGroup(WCAgentGroup template) {
        this.agentGroups.remove(template);
    }

    protected void moveUpAgentGroup(WCAgentGroup agentGroup) {
        int index = this.agentGroups.indexOf(agentGroup);
        this.moveUp(this.agentGroups, index);
    }

    protected void moveDownAgentGroup(WCAgentGroup agentGroup) {
        int index = this.agentGroups.indexOf(agentGroup);
        this.moveDown(this.agentGroups, index);
    }

    protected void addRelationGroup(WCRelationGroup template) {
        this.relationGroups.add(template);
    }

    protected void removeRelationGroup(WCRelationGroup template) {
        this.relationGroups.remove(template);
    }

    protected void moveUpRelationGroup(WCRelationGroup relationGroup) {
        int index = this.relationGroups.indexOf(relationGroup);
        this.moveUp(this.relationGroups, index);
    }

    protected void moveDownRelationGroup(WCRelationGroup relationGroup) {
        int index = this.relationGroups.indexOf(relationGroup);
        this.moveDown(this.relationGroups, index);
    }

    protected void addParameter(WCParameter parameter) {
        this.parameters.add(parameter);
    }

    protected void removeParameter(WCParameter parameter) {
        this.parameters.remove(parameter);
    }

    protected void moveUpParameter(WCParameter parameter) {
        int index = this.parameters.indexOf(parameter);
        this.moveUp(this.parameters, index);
    }

    protected void moveDownParameter(WCParameter parameter) {
        int index = this.parameters.indexOf(parameter);
        this.moveDown(this.parameters, index);
    }

    protected void addRandomNumberGeneratorSetting(WCRandomNumberGeneratorSetting generator) {
        this.randomNumberGeneratorSettings.add(generator);
    }

    protected void removeRandomNumberGeneratorSetting(WCRandomNumberGeneratorSetting generator) {
        this.randomNumberGeneratorSettings.remove(generator);
    }

    protected void moveUpRandomNumberGenerator(WCRandomNumberGeneratorSetting parameter) {
        int index = this.parameters.indexOf(parameter);
        this.moveUp(this.parameters, index);
    }

    protected void moveDownRandomNumberGenerator(WCRandomNumberGeneratorSetting parameter) {
        int index = this.parameters.indexOf(parameter);
        this.moveDown(this.parameters, index);
    }

    private void moveUp(List list, int index) {
        if (!$assertionsDisabled && index <= 0) {
            throw new AssertionError();
        }
        Collections.swap(list, index, index - 1);
    }

    private void moveDown(List list, int index) {
        if (!$assertionsDisabled && index == -1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.agentGroups.size() - 1) {
            throw new AssertionError();
        }
        Collections.swap(list, index, index + 1);
    }

    public List getAgentGroups() {
        return new ArrayList(this.agentGroups);
    }

    public List getParameters() {
        return new ArrayList(this.parameters);
    }

    public List getRelationGroups() {
        return new ArrayList(this.relationGroups);
    }

    public List getRandomNumberGeneratorSettings() {
        return new ArrayList(this.randomNumberGeneratorSettings);
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public WCClockSetting getClockSetting() {
        return this.clockSetting;
    }

    protected void setDescription(String comment) {
        this.description = comment;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setClockSetting(WCClockSetting setting) {
        this.clockSetting = setting;
    }
}

