/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCBlock;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorConstants;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCCodeGeneratorCore;
import org.boxed_economy.componentbuilder.worldcomposer.codegen.WCForLoop;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPatternCodeGenerator;

public class WCAllRelationPatternCodeGenerator
extends WCRelationPatternCodeGenerator {
    public WCAllRelationPatternCodeGenerator(WCRelationGroup relationGroup, WCCodeGeneratorCore generator) {
        super(relationGroup, generator);
    }

    public WCBlock[] getAddRelationProcess() {
        WCBlock[] addRelationProcess = new WCBlock[]{this.createPreprocess(), this.createProcess()};
        return addRelationProcess;
    }

    protected WCBlock createPreprocess() {
        WCBlock preprocess = new WCBlock();
        preprocess.setComment(WCCodeGeneratorConstants.COMMENT_PRE_ADD_RELTION);
        List sourceAgents = this.getRelationGroup().getSourceAgentGroups();
        this.composeAgentList(preprocess, sourceAgents, "sourceAgents");
        List targetAgents = this.getRelationGroup().getTargetAgentGroups();
        this.composeAgentList(preprocess, targetAgents, "targetAgents");
        return preprocess;
    }

    protected WCBlock createProcess() {
        WCBlock addRelations = null;
        List sourceAgents = this.getRelationGroup().getSourceAgentGroups();
        List targetAgents = this.getRelationGroup().getTargetAgentGroups();
        if (this.isSingleAgent(sourceAgents) && this.isSingleAgent(targetAgents)) {
            addRelations = this.createNoLoopAddRelations();
        } else if (this.isSingleAgent(sourceAgents) && !this.isSingleAgent(targetAgents)) {
            addRelations = this.createTargetLoopAddRelations();
        } else if (!this.isSingleAgent(sourceAgents) && this.isSingleAgent(targetAgents)) {
            addRelations = this.createSourceLoopAddRelaitons();
        } else if (!this.isSingleAgent(sourceAgents) && !this.isSingleAgent(targetAgents)) {
            addRelations = this.createBothLoopAddRelations();
        }
        return addRelations;
    }

    protected WCBlock createTargetLoopAddRelations() {
        WCBlock block = new WCBlock();
        WCBlock sourcePreprocess = new WCBlock();
        sourcePreprocess.addStatement(this.getSourceAgentDeclaration("0"));
        block.addStatement(sourcePreprocess);
        WCForLoop loop = new WCForLoop("targetAgents.size()");
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(String.valueOf(this.getTargetAgentDeclaration("i")) + WCCodeGeneratorConstants.CR);
        loop.addStatement(preprocess.toString());
        loop.addStatement(this.createComposeRelationBlock());
        block.addStatement(loop);
        return block;
    }

    protected WCBlock createSourceLoopAddRelaitons() {
        WCBlock block = new WCBlock();
        WCBlock sourcePreprocess = new WCBlock();
        sourcePreprocess.addStatement(this.getTargetAgentDeclaration("0"));
        block.addStatement(sourcePreprocess);
        WCForLoop process = new WCForLoop("sourceAgents.size()");
        process.setComment(WCCodeGeneratorConstants.COMMENT_ADD_REALTIONS);
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(String.valueOf(this.getSourceAgentDeclaration("i")) + WCCodeGeneratorConstants.CR);
        process.addStatement(preprocess.toString());
        process.addStatement(this.createComposeRelationBlock());
        block.addStatement(process);
        return block;
    }

    protected WCBlock createBothLoopAddRelations() {
        WCForLoop process = new WCForLoop("sourceAgents.size()");
        process.setComment(WCCodeGeneratorConstants.COMMENT_ADD_REALTIONS);
        WCBlock sourcePreprocess = new WCBlock();
        sourcePreprocess.addStatement(this.getSourceAgentDeclaration("i"));
        process.addStatement(sourcePreprocess);
        WCForLoop innerLoop = new WCForLoop("targetAgents.size()");
        innerLoop.setIndexVariable("j");
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(String.valueOf(this.getTargetAgentDeclaration("j")) + WCCodeGeneratorConstants.CR);
        innerLoop.addStatement(preprocess.toString());
        innerLoop.addStatement(this.createComposeRelationBlock());
        process.addStatement(innerLoop.toString());
        return process;
    }

    protected WCBlock createNoLoopAddRelations() {
        WCBlock loop = new WCBlock();
        loop.setComment(WCCodeGeneratorConstants.COMMENT_ADD_REALTIONS);
        WCBlock preprocess = new WCBlock();
        preprocess.addStatement(this.getSourceAgentDeclaration("0"));
        preprocess.addStatement(String.valueOf(this.getTargetAgentDeclaration("0")) + WCCodeGeneratorConstants.CR);
        loop.addStatement(preprocess.toString());
        loop.addStatement(this.createComposeRelationBlock());
        return loop;
    }

    protected WCBlock createComposeRelationBlock() {
        WCBlock block = new WCBlock();
        block.addStatement("if(sourceAgent!=targetAgent){");
        this.addAddRelationBlock(block);
        block.addStatement("}");
        return block;
    }

    protected void addAddRelationBlock(WCBlock block) {
        block.addStatement(String.valueOf(WCCodeGeneratorConstants.COMMENT_ADD_RELTION_FROM_SOURCE) + this.getCodeGeneratorUtil().exInvokeMethod("sourceAgent", "addRelation", this.getCodeGeneratorUtil().createRelationTypeArgument(this.getRelationGroup().getType(), "targetAgent")));
        if (this.getRelationGroup().isTwoWay()) {
            block.addStatement(String.valueOf(WCCodeGeneratorConstants.COMMENT_ADD_RELTION_FROM_TARGET) + this.getCodeGeneratorUtil().exInvokeMethod("targetAgent", "addRelation", this.getCodeGeneratorUtil().createRelationTypeArgument(this.getRelationGroup().getType(), "sourceAgent")));
        }
    }
}

