/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern;

import java.util.List;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCCellRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCDefaultCustomComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class WCCellCustomComposite
extends WCDefaultCustomComposite {
    private static final int DIRECTION_MAX = 10;
    private static final String LOOP_EXPRESSION = "Loop";
    private static final String NO_LOOP_EXPRESSION = "No Loop";
    private Combo directionCombo;
    private Combo dimensionCombo;
    private Combo loopCombo;

    public WCCellCustomComposite(Composite parent, int style, List sourceAgents, List targetAgents, WCDocument document, WCRelationPattern pattern) {
        super(parent, style, sourceAgents, targetAgents, document, pattern);
    }

    protected void initializeParameterComposite() {
        Composite parameterComposite = new Composite((Composite)this, 0);
        parameterComposite.setLayoutData((Object)new GridData(1808));
        parameterComposite.setLayout((Layout)new RowLayout(512));
        this.initializeDirectionCombo(parameterComposite);
        this.initializeLoopCombo(parameterComposite);
    }

    private void initializeDirectionCombo(Composite parameterComposite) {
        Label direrctionLabel = new Label(parameterComposite, 0);
        direrctionLabel.setText("Direction:");
        this.directionCombo = new Combo(parameterComposite, 2048);
        this.directionCombo.setLayoutData((Object)new RowData(200, -1));
        int i = 0;
        while (i < 10) {
            this.directionCombo.add(String.valueOf(i + 1));
            ++i;
        }
        this.directionCombo.setText(String.valueOf(this.getCellRelationPattern().getDirection()));
        this.directionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCCellCustomComposite.this.directionChanged(e);
            }
        });
    }

    private void initializeDimensionCombo(Composite parameterComposite) {
        Label dimensionLabel = new Label(parameterComposite, 0);
        dimensionLabel.setText("Dimension:");
        this.dimensionCombo = new Combo(parameterComposite, 2048);
        this.dimensionCombo.setLayoutData((Object)new RowData(200, -1));
        this.dimensionCombo.add("1");
        this.dimensionCombo.add("2");
        this.dimensionCombo.setText(String.valueOf(this.getCellRelationPattern().getDimension()));
        this.dimensionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCCellCustomComposite.this.dimensionChanged(e);
            }
        });
    }

    private void initializeLoopCombo(Composite parameterComposite) {
        Label loopLabel = new Label(parameterComposite, 0);
        loopLabel.setText("LoopSetting:");
        this.loopCombo = new Combo(parameterComposite, 2048);
        this.loopCombo.setLayoutData((Object)new RowData(200, -1));
        this.loopCombo.add(LOOP_EXPRESSION);
        this.loopCombo.add(NO_LOOP_EXPRESSION);
        if (this.getCellRelationPattern().isLoop()) {
            this.loopCombo.select(0);
        } else {
            this.loopCombo.select(1);
        }
        this.loopCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCCellCustomComposite.this.loopSettingChanged(e);
            }
        });
    }

    public void performFinish() {
        String direction = this.directionCombo.getText();
        boolean isLoop = this.loopCombo.getText().equals(LOOP_EXPRESSION);
        this.getCellRelationPattern().setDirection(direction);
        this.getCellRelationPattern().setLoop(isLoop);
    }

    public boolean canFinish() {
        return true;
    }

    public WCCellRelationPattern getCellRelationPattern() {
        return (WCCellRelationPattern)this.getRelationPattern();
    }

    protected void directionChanged(ModifyEvent e) {
        this.stateChanged();
    }

    protected void loopSettingChanged(ModifyEvent e) {
        this.stateChanged();
    }

    protected void dimensionChanged(ModifyEvent e) {
        this.stateChanged();
    }
}

