/*
 * Decompiled with CFR 0.152.
 */
package org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern;

import java.util.List;
import org.boxed_economy.componentbuilder.util.ObjectCombo;
import org.boxed_economy.componentbuilder.worldcomposer.editor.WCRandomNumberGeneratorCombo;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCAgentGroup;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCDocument;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRandomNumberGeneratorSetting;
import org.boxed_economy.componentbuilder.worldcomposer.model.WCRelationPattern;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCDefaultCustomComposite;
import org.boxed_economy.componentbuilder.worldcomposer.model.relationpattern.WCRandomRelationPattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WCRandomCustomComposite
extends WCDefaultCustomComposite {
    private Text numberText;
    private ObjectCombo generatorCombo;

    public WCRandomCustomComposite(Composite parent, int style, List sourceAgents, List targetAgents, WCDocument document, WCRelationPattern pattern) {
        super(parent, style, sourceAgents, targetAgents, document, pattern);
    }

    protected void initializeParameterComposite() {
        Composite parameterComposite = new Composite((Composite)this, 0);
        parameterComposite.setLayoutData((Object)new GridData(1808));
        parameterComposite.setLayout((Layout)new RowLayout(512));
        Label numberLabel = new Label(parameterComposite, 0);
        numberLabel.setText("Number:");
        this.numberText = new Text(parameterComposite, 2048);
        this.numberText.setLayoutData((Object)new RowData(220, -1));
        this.numberText.setText(String.valueOf(this.getRandomRelationPattern().getNumberOfRelation()));
        this.numberText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WCRandomCustomComposite.this.numberTextChanged(e);
            }
        });
        Label generatorLabel = new Label(parameterComposite, 0);
        generatorLabel.setText("Random Number Generator:");
        this.generatorCombo = new WCRandomNumberGeneratorCombo(parameterComposite, 12);
        this.generatorCombo.setLayoutData(new RowData(205, -1));
        this.generatorCombo.setObjects(this.getDocument().getWorldTemplate().getRandomNumberGeneratorSettings());
        this.generatorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WCRandomCustomComposite.this.generatorSelected(e);
            }
        });
        this.generatorCombo.select(this.getRandomRelationPattern().getGeneratorSetting());
        if (this.generatorCombo.getSelectionIndex() == -1) {
            this.generatorCombo.select(0);
        }
    }

    public void performFinish() {
        int number = Integer.parseInt(this.numberText.getText());
        this.getRandomRelationPattern().setNumberOfRelation(number);
        this.getRandomRelationPattern().setGeneratorSetting((WCRandomNumberGeneratorSetting)this.generatorCombo.getSelectionObject());
    }

    public boolean canFinish() {
        try {
            Integer.parseInt(this.numberText.getText());
            if (this.isSingleAgent(this.getSourceAgents()) && this.isSingleAgent(this.getTargetAgents())) {
                StatusInfo status = new StatusInfo(1, "Source and Target Agents have only one agent.So can not generate Random Relation Pattern.");
                ErrorDialog.openError((Shell)this.getShell(), (String)"Notice", (String)" ", (IStatus)status);
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    public WCRandomRelationPattern getRandomRelationPattern() {
        return (WCRandomRelationPattern)this.getRelationPattern();
    }

    protected boolean isSingleAgent(List agents) {
        if (agents.size() > 1) {
            return false;
        }
        if (agents.isEmpty()) {
            return true;
        }
        WCAgentGroup agentGroup = (WCAgentGroup)agents.get(0);
        return agentGroup.getNumber().getValueAsString().equals("1");
    }

    protected void numberTextChanged(ModifyEvent e) {
        this.stateChanged();
    }

    protected void generatorSelected(SelectionEvent e) {
        this.stateChanged();
    }
}

