/*
 * Decompiled with CFR 0.152.
 */
package sdeditor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.EventObject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.AlignmentAction;
import org.eclipse.gef.ui.actions.DirectEditAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.parts.GraphicalEditorWithPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.parts.SelectionSynchronizer;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.gef.ui.stackview.CommandStackInspectorPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import sdeditor.SDEditDomain;
import sdeditor.SDEditorException;
import sdeditor.SDExportSVGAction;
import sdeditor.SDPartsFactory;
import sdeditor.SDSelectAllAction;
import sdeditor.SDTreeOutlinePage;
import sdeditor.codegen.SDCodeGenerateAction;
import sdeditor.codegen.SDCodeGenerator;
import sdeditor.editpart.SDEditPartFactory;
import sdeditor.editpart.propertyedit.SDPropertyEditAction;
import sdeditor.model.SDDocument;
import sdeditor.model.SDProject;
import sdeditor.model.serialize.SDDocumentSerializer;
import trier.diagrameditor.action.EEvenIntervalAction;
import trier.diagrameditor.action.EStepMoveAction;

public class SDEditor
extends GraphicalEditorWithPalette
implements CommandStackListener {
    private static final String CONTEXT_MENU = "sdeditor.model.contextmenu";
    private SDPartsFactory factory = new SDPartsFactory(this);
    private SDCodeGenerator codeGenerator;
    private SDDocumentSerializer serializer;
    private PaletteRoot palette;
    private KeyHandler keyHandler;
    private ContextMenuProvider contextMenuProvider;
    private boolean dirty = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setEditDomain(new SDEditDomain((IEditorPart)this));
        super.init(site, input);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)super.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        ZoomInAction zoomIn = new ZoomInAction(root.getZoomManager());
        ZoomOutAction zoomOut = new ZoomOutAction(root.getZoomManager());
        this.getActionRegistry().registerAction((IAction)zoomIn);
        this.getActionRegistry().registerAction((IAction)zoomOut);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomIn);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOut);
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory((EditPartFactory)new SDEditPartFactory());
        ((FigureCanvas)viewer.getControl()).setScrollBarVisibility(FigureCanvas.ALWAYS);
        ContextMenuProvider provider = this.getContextMenuProvider();
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu(CONTEXT_MENU, (MenuManager)provider, (ISelectionProvider)viewer);
        viewer.setKeyHandler(this.getKeyHandler().setParent((KeyHandler)new GraphicalViewerKeyHandler((GraphicalViewer)viewer)));
    }

    protected void initializeGraphicalViewer() {
        super.getGraphicalViewer().setContents((Object)this.getSDEditDomain().getRootStateMachine());
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = new DirectEditAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SDPropertyEditAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 4);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 8);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 32);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AlignmentAction((IWorkbenchPart)this, 16);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 2);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 0);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EStepMoveAction((IWorkbenchPart)this, 3);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EEvenIntervalAction((IWorkbenchPart)this, 0);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new EEvenIntervalAction((IWorkbenchPart)this, 1);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new SDExportSVGAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        action = new SDSelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        registry.registerAction((IAction)new SDCodeGenerateAction((IEditorPart)this));
    }

    protected void initializeCodeGenerator() {
        SDCodeGenerator generator = this.getCodeGenerator();
        if (generator != null) {
            generator.setDomain(this.getSDEditDomain());
            generator.setFile(this.getFile());
        }
    }

    protected void initializeSerializer() {
        SDDocumentSerializer serializer = this.getSerializer();
        serializer.setProject(this.getSDEditDomain().getProject());
    }

    public void doSave(IProgressMonitor progressMonitor) {
        try {
            this.saveImpl(progressMonitor);
            this.getCommandStack().markSaveLocation();
            this.setDirty(false);
        }
        catch (Exception ex) {
            throw new SDEditorException("exception caught in doSave()", ex);
        }
    }

    public void doSaveAs() {
        throw new RuntimeException("you cannot save as");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        try {
            super.setInput(input);
            this.setTitle(this.getFile().getName());
            SDProject project = SDProject.getProject(this.getFile());
            this.getSDEditDomain().setProject(project);
            this.initializeCodeGenerator();
            this.initializeSerializer();
            this.loadImpl();
        }
        catch (Exception ex) {
            throw new SDEditorException("exception caught in setInput()", ex);
        }
    }

    private void saveImpl(IProgressMonitor progress) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SDDocument doc = this.getSDEditDomain().getDocument();
        this.serializer.serialize(doc, out);
        out.close();
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        this.getFile().setContents((InputStream)in, true, false, progress);
        in.close();
    }

    private void loadImpl() throws Exception {
        try {
            InputStream in = this.getFile().getContents(false);
            SDDocument document = this.serializer.unSerialize(in);
            in.close();
            this.getSDEditDomain().setDocument(document);
        }
        catch (Throwable th) {
            th.printStackTrace();
            this.getSDEditDomain().setDocument(new SDDocument());
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void commandStackChanged(EventObject event) {
        super.commandStackChanged(event);
        this.setDirty(true);
    }

    private void setDirty(boolean dirty) {
        if (!this.dirty && dirty) {
            this.dirty = true;
            this.firePropertyChange(257);
        }
        if (this.dirty && !dirty) {
            this.dirty = false;
            this.firePropertyChange(257);
        }
    }

    public SDCodeGenerator getCodeGenerator() {
        return this.codeGenerator;
    }

    protected void setCodeGenerator(SDCodeGenerator codeGenerator) {
        this.codeGenerator = codeGenerator;
        this.initializeCodeGenerator();
    }

    public SDDocumentSerializer getSerializer() {
        if (this.serializer == null) {
            this.serializer = SDDocumentSerializer.createInstance();
        }
        return this.serializer;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.palette == null) {
            this.palette = this.factory.createPalette();
        }
        return this.palette;
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = this.factory.createKeyHandler();
        }
        return this.keyHandler;
    }

    protected ContextMenuProvider getContextMenuProvider() {
        if (this.contextMenuProvider == null) {
            this.contextMenuProvider = this.factory.createContextMenuProvider((EditPartViewer)this.getGraphicalViewer());
        }
        return this.contextMenuProvider;
    }

    protected SelectionSynchronizer getSelectionSynchronizer() {
        return super.getSelectionSynchronizer();
    }

    protected DefaultEditDomain getEditDomain() {
        return super.getEditDomain();
    }

    protected ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    public SDEditDomain getSDEditDomain() {
        return (SDEditDomain)super.getEditDomain();
    }

    public IFile getFile() {
        return ((IFileEditorInput)this.getEditorInput()).getFile();
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void gotoMarker(IMarker marker) {
        throw new RuntimeException("cannot use gotoMarker()");
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.ui.stackview.CommandStackInspectorPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            return new CommandStackInspectorPage(this.getCommandStack());
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            return new SDTreeOutlinePage((EditPartViewer)new TreeViewer(), this);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return ((ScalableFreeformRootEditPart)this.getGraphicalViewer().getRootEditPart()).getZoomManager();
        }
        return super.getAdapter(type);
    }
}

