/*
 * Decompiled with CFR 0.152.
 */
package sdeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.palette.ConnectionCreationToolEntry;
import org.eclipse.gef.palette.CreationToolEntry;
import org.eclipse.gef.palette.MarqueeToolEntry;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.SelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.requests.SimpleFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import sdeditor.SDEditor;
import sdeditor.SDPlugin;
import sdeditor.model.SDSelfTransition;

public class SDPartsFactory {
    private static final String GROUP_PROPERTY = "sdeditor.property";
    private static final String GROUP_UNDO = "sdeditor.property";
    private static final String GROUP_EDITPART = "sdeditor.editpart";
    private SDEditor editor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public SDPartsFactory(SDEditor editor) {
        this.editor = editor;
    }

    protected PaletteRoot createPalette() {
        PaletteRoot paletteRoot = new PaletteRoot();
        paletteRoot.addAll(this.createCategories(paletteRoot));
        return paletteRoot;
    }

    protected KeyHandler createKeyHandler() {
        KeyHandler handler = new KeyHandler();
        handler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.editor.getActionRegistry().getAction((Object)"delete"));
        handler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.editor.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        handler.put(KeyStroke.getPressed((int)0x1000004, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove right"));
        handler.put(KeyStroke.getPressed((int)0x1000003, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove left"));
        handler.put(KeyStroke.getPressed((int)0x1000001, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove up"));
        handler.put(KeyStroke.getPressed((int)0x1000002, (int)0), this.editor.getActionRegistry().getAction((Object)"$stepmove down"));
        return handler;
    }

    protected ContextMenuProvider createContextMenuProvider(EditPartViewer viewer) {
        return new SDContextMenuProvider(viewer);
    }

    private List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        categories.add(this.createControlCategory(root));
        categories.add(this.createStateCategory());
        categories.add(this.createTransitionCategory());
        return categories;
    }

    private PaletteContainer createControlCategory(PaletteRoot root) {
        PaletteGroup category = new PaletteGroup("Control");
        ArrayList<SelectionToolEntry> entries = new ArrayList<SelectionToolEntry>();
        SelectionToolEntry tool = new SelectionToolEntry();
        entries.add(tool);
        root.setDefaultEntry((ToolEntry)tool);
        tool = new MarqueeToolEntry();
        entries.add(tool);
        category.addAll(entries);
        return category;
    }

    private PaletteContainer createStateCategory() {
        PaletteDrawer category = new PaletteDrawer("State");
        ArrayList<CreationToolEntry> entries = new ArrayList<CreationToolEntry>();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDCompositeState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CreationToolEntry tool = new CreationToolEntry("State", "create new state", (CreationFactory)new SimpleFactory((Class)clazz), SDPlugin.getImageDescriptor("icon_state"), SDPlugin.getImageDescriptor("icon_state"));
        entries.add(tool);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("sdeditor.model.SDInitialState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tool = new CreationToolEntry("Initial State", "create new initial state", (CreationFactory)new SimpleFactory((Class)clazz2), SDPlugin.getImageDescriptor("icon_initialstate"), SDPlugin.getImageDescriptor("icon_initialstate"));
        entries.add(tool);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("sdeditor.model.SDTerminalState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tool = new CreationToolEntry("Terminal State", "create new terminal state", (CreationFactory)new SimpleFactory((Class)clazz3), SDPlugin.getImageDescriptor("icon_finalstate"), SDPlugin.getImageDescriptor("icon_finalstate"));
        entries.add(tool);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("sdeditor.model.SDHistoryState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        tool = new CreationToolEntry("History State", "create new history state", (CreationFactory)new SimpleFactory((Class)clazz4), SDPlugin.getImageDescriptor("icon_hstate"), SDPlugin.getImageDescriptor("icon_hstate"));
        entries.add(tool);
        category.addAll(entries);
        return category;
    }

    private PaletteContainer createTransitionCategory() {
        PaletteDrawer category = new PaletteDrawer("Transition");
        ArrayList<ConnectionCreationToolEntry> entries = new ArrayList<ConnectionCreationToolEntry>();
        ConnectionCreationToolEntry tool = new ConnectionCreationToolEntry("Transition", "create new transition", null, SDPlugin.getImageDescriptor("icon_transition"), SDPlugin.getImageDescriptor("icon_transition"));
        entries.add(tool);
        tool = new CreationToolEntry("Right", "create new right self transition", this.getRightSelfTransitionFactory(), SDPlugin.getImageDescriptor("icon_trans_right"), SDPlugin.getImageDescriptor("icon_trans_right"));
        entries.add(tool);
        tool = new CreationToolEntry("Left", "create new left self transition", this.getLeftSelfTransitionFactory(), SDPlugin.getImageDescriptor("icon_trans_left"), SDPlugin.getImageDescriptor("icon_trans_left"));
        entries.add(tool);
        tool = new CreationToolEntry("Top", "create new top self transition", this.getTopSelfTransitionFactory(), SDPlugin.getImageDescriptor("icon_trans_top"), SDPlugin.getImageDescriptor("icon_trans_top"));
        entries.add(tool);
        tool = new CreationToolEntry("Bottom", "create new bottom self transition", this.getBottomSelfTransitionFactory(), SDPlugin.getImageDescriptor("icon_trans_bottom"), SDPlugin.getImageDescriptor("icon_trans_bottom"));
        entries.add(tool);
        category.addAll(entries);
        return category;
    }

    private CreationFactory getRightSelfTransitionFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return SDSelfTransition.createSelfTransition(1);
            }

            public Object getObjectType() {
                return "right";
            }
        };
    }

    private CreationFactory getLeftSelfTransitionFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return SDSelfTransition.createSelfTransition(2);
            }

            public Object getObjectType() {
                return "left";
            }
        };
    }

    private CreationFactory getTopSelfTransitionFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return SDSelfTransition.createSelfTransition(3);
            }

            public Object getObjectType() {
                return "top";
            }
        };
    }

    private CreationFactory getBottomSelfTransitionFactory() {
        return new CreationFactory(){

            public Object getNewObject() {
                return SDSelfTransition.createSelfTransition(4);
            }

            public Object getObjectType() {
                return "bottom";
            }
        };
    }

    private class SDContextMenuProvider
    extends ContextMenuProvider {
        private ActionRegistry registry;

        public SDContextMenuProvider(EditPartViewer viewer) {
            super(viewer);
            this.registry = SDPartsFactory.this.editor.getActionRegistry();
        }

        public void buildContextMenu(IMenuManager menu) {
            this.addStandardActionGroups(menu);
            this.addPropertyContributions(menu);
            menu.add((IContributionItem)new Separator());
            this.addEditDomainContributions(menu);
            menu.add((IContributionItem)new Separator());
            this.addEditorPartContributions(menu);
            menu.add((IContributionItem)new Separator());
            this.addEditPartViewerContributions(menu);
        }

        private void addPropertyContributions(IMenuManager menu) {
            IAction action = this.registry.getAction((Object)"$property edit");
            if (action.isEnabled()) {
                menu.appendToGroup("sdeditor.property", action);
            }
        }

        private void addEditDomainContributions(IMenuManager menu) {
            menu.appendToGroup("sdeditor.property", this.registry.getAction((Object)"undo"));
            menu.appendToGroup("sdeditor.property", this.registry.getAction((Object)"redo"));
        }

        private void addEditorPartContributions(IMenuManager menu) {
            menu.add(this.registry.getAction((Object)"save"));
        }

        private void addEditPartViewerContributions(IMenuManager menu) {
            IAction action = this.registry.getAction((Object)"delete");
            if (action.isEnabled()) {
                menu.add(action);
            }
            MenuManager submenu = new MenuManager("Alignment");
            action = this.registry.getAction((Object)"org.eclipse.gef.align_left");
            if (action.isEnabled()) {
                submenu.add(action);
            }
            if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_center")).isEnabled()) {
                submenu.add(action);
            }
            if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_right")).isEnabled()) {
                submenu.add(action);
            }
            if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_top")).isEnabled()) {
                submenu.add(action);
            }
            if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_middle")).isEnabled()) {
                submenu.add(action);
            }
            if ((action = this.registry.getAction((Object)"org.eclipse.gef.align_bottom")).isEnabled()) {
                submenu.add(action);
            }
            if (!submenu.isEmpty()) {
                menu.appendToGroup(SDPartsFactory.GROUP_EDITPART, (IContributionItem)submenu);
            }
        }

        private void addStandardActionGroups(IMenuManager menu) {
            menu.add((IContributionItem)new Separator("sdeditor.property"));
            menu.add((IContributionItem)new Separator("sdeditor.property"));
            menu.add((IContributionItem)new Separator(SDPartsFactory.GROUP_EDITPART));
        }
    }
}

