/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.codegen;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import sdeditor.SDEditorException;

public class SDCodeGenerationEnvironment {
    private static final Logger logger;
    private IFile file = null;
    private IJavaProject javaProject = null;
    private IPackageFragmentRoot packageRoot = null;
    private IPackageFragment pack = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.codegen.SDCodeGenerationEnvironment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public SDCodeGenerationEnvironment(IFile file) throws JavaModelException {
        this.file = file;
        this.initialize();
    }

    private void initialize() throws JavaModelException {
        this.initializeJavaProject();
        this.initializePackageRoot();
        this.initializePackage();
    }

    private void initializeJavaProject() {
        this.javaProject = JavaCore.create((IProject)this.file.getProject());
        if (this.javaProject == null) {
            throw new SDEditorException("cannot initialize JavaProject");
        }
    }

    private void initializePackageRoot() throws JavaModelException {
        IJavaProject javaProject = this.getJavaProject();
        IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                this.packageRoot = roots[i];
            }
            ++i;
        }
        if (this.packageRoot == null) {
            throw new SDEditorException("cannot initialize PackageFragmentRoot");
        }
    }

    private void initializePackage() throws JavaModelException {
        IPackageFragmentRoot root = this.getPackageRoot();
        String packName = SDCodeGenerationEnvironment.getPackageName(this.file.getParent(), this.file.getProject(), root);
        this.pack = root.getPackageFragment(packName);
        if (!this.pack.exists()) {
            this.pack = root.createPackageFragment(packName, true, null);
        }
        if (!this.pack.exists()) {
            throw new SDEditorException("cannot initialize Package");
        }
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IPackageFragmentRoot getPackageRoot() {
        return this.packageRoot;
    }

    public IPackageFragment getPackage() {
        return this.pack;
    }

    private static String getPackageName(IContainer dir, IProject project, IPackageFragmentRoot root) {
        String pathName = dir.getProjectRelativePath().toString();
        String rootName = root.getPath().toString();
        String projectName = project.getFullPath().toString();
        pathName = SDCodeGenerationEnvironment.trimSlash(pathName);
        rootName = SDCodeGenerationEnvironment.trimSlash(rootName);
        projectName = SDCodeGenerationEnvironment.trimSlash(projectName);
        rootName = rootName.replaceFirst(projectName, "");
        rootName = SDCodeGenerationEnvironment.trimSlash(rootName);
        pathName = pathName.replaceFirst(rootName, "");
        pathName = SDCodeGenerationEnvironment.trimSlash(pathName);
        String packageName = pathName.replace('/', '.');
        return packageName;
    }

    private static String trimSlash(String path) {
        String pathSeparator = "" + '/';
        if (path.startsWith(pathSeparator)) {
            path = path.replaceFirst(pathSeparator, "");
        }
        return path;
    }
}

