/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ManhattanConnectionRouter;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import sdeditor.editpart.policy.SDTransitionBendpointEditPolicy;
import sdeditor.editpart.policy.SDTransitionEditPolicy;
import sdeditor.editpart.propertyedit.SDTransitionEditDialog;
import sdeditor.figure.SDFigureFactory;
import sdeditor.model.SDElement;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDTransition;
import sdeditor.model.SDTransitionLabel;

public class SDTransitionEditPart
extends AbstractConnectionEditPart
implements PropertyChangeListener {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.editpart.SDTransitionEditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public SDElement getElement() {
        return (SDElement)this.getModel();
    }

    public SDTransition getTransition() {
        return (SDTransition)this.getModel();
    }

    protected PolylineConnection getTransitionFigure() {
        return (PolylineConnection)this.getFigure();
    }

    public void activate() {
        if (super.isActive()) {
            return;
        }
        super.activate();
        this.getElement().addPropertyChangeListener(this);
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        super.deactivate();
        this.getElement().removePropertyChangeListener(this);
    }

    public void activateFigure() {
        super.activateFigure();
        this.getFigure().addPropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
    }

    public void deactivateFigure() {
        this.getFigure().removePropertyChangeListener("connectionRouter", (PropertyChangeListener)this);
        super.deactivateFigure();
    }

    protected void createEditPolicies() {
        super.installEditPolicy((Object)"ConnectionEditPolicy", (EditPolicy)new SDTransitionEditPolicy());
        super.installEditPolicy((Object)"Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.initializeBendpointEditPolicy();
    }

    private void initializeBendpointEditPolicy() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            this.installEditPolicy("Connection Bendpoint Policy", null);
            logger.debug((Object)"Editpolicy initialized for manhattan Router");
        } else {
            this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new SDTransitionBendpointEditPolicy());
            logger.debug((Object)"Editpolicy initialized for bendpoint Router");
        }
    }

    protected IFigure createFigure() {
        return SDFigureFactory.createFigure(this.getElement());
    }

    protected List getModelChildren() {
        ArrayList<SDTransitionLabel> child = new ArrayList<SDTransitionLabel>();
        child.add(this.getTransition().getLabel());
        return child;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("connectionRouter".equals(propName)) {
            this.initializeBendpointEditPolicy();
            this.refreshVisuals();
        }
        if (propName.equals("rectangle")) {
            this.refreshVisuals();
            this.refreshChildren();
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshBendpoints();
    }

    private void refreshBendpoints() {
        if (this.getConnectionFigure().getConnectionRouter() instanceof ManhattanConnectionRouter) {
            return;
        }
        List bendpoints = this.getTransition().getBendpoints();
        ArrayList<RelativeBendpoint> constraint = new ArrayList<RelativeBendpoint>();
        Iterator i = bendpoints.iterator();
        while (i.hasNext()) {
            SDRelativePoint p = (SDRelativePoint)i.next();
            RelativeBendpoint bp = new RelativeBendpoint((Connection)this.getTransitionFigure());
            bp.setRelativeDimensions(p.getD1(), p.getD2());
            bp.setWeight(p.getWeight());
            constraint.add(bp);
        }
        this.getTransitionFigure().setRoutingConstraint(constraint);
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" || request.getType() == "property edit") {
            this.showPropertyDialog();
        }
    }

    public boolean understandsRequest(Request request) {
        if (request.getType() == "open" || request.getType() == "property edit") {
            return true;
        }
        return super.understandsRequest(request);
    }

    private void showPropertyDialog() {
        SDTransitionEditDialog dialog = new SDTransitionEditDialog(this.getViewer().getEditDomain(), (SDTransition)this.getModel());
        dialog.show();
    }
}

