/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.policy;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.BendpointEditPolicy;
import org.eclipse.gef.requests.BendpointRequest;
import sdeditor.SDEditDomain;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDTransition;

public class SDTransitionBendpointEditPolicy
extends BendpointEditPolicy {
    protected Command getCreateBendpointCommand(BendpointRequest request) {
        SDTransition trans = this.getTransition();
        SDRelativePoint p = this.createRelativePoint(request.getLocation());
        int index = request.getIndex();
        return this.getDomain().AddBendpointToTransitionCommand(trans, p, index);
    }

    protected Command getDeleteBendpointCommand(BendpointRequest request) {
        SDTransition trans = this.getTransition();
        int index = request.getIndex();
        return this.getDomain().RemoveBendpointFromTransitionCommand(trans, index);
    }

    protected Command getMoveBendpointCommand(BendpointRequest request) {
        SDTransition trans = this.getTransition();
        SDRelativePoint p = this.createRelativePoint(request.getLocation());
        int index = request.getIndex();
        return this.getDomain().MoveBendpointInTransitionCommand(trans, p, index);
    }

    private SDTransition getTransition() {
        return (SDTransition)this.getHost().getModel();
    }

    private SDEditDomain getDomain() {
        return (SDEditDomain)this.getHost().getRoot().getViewer().getEditDomain();
    }

    private SDRelativePoint createRelativePoint(Point p) {
        return SDRelativePoint.createInstance(p, this.getSourcePoint(), this.getTargetPoint());
    }

    private Point getSourcePoint() {
        return this.getConnection().getSourceAnchor().getReferencePoint();
    }

    private Point getTargetPoint() {
        return this.getConnection().getTargetAnchor().getReferencePoint();
    }
}

