/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.propertyedit;

import java.util.Iterator;
import org.eclipse.gef.EditDomain;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;
import sdeditor.SDEditDomain;
import sdeditor.editpart.propertyedit.SDAbstractAvailableManager;
import sdeditor.editpart.propertyedit.SDCreateGuardConditionDialog;
import sdeditor.editpart.propertyedit.SDGuardConditionNameValidator;
import sdeditor.model.SDInternalGuardCondition;

public class SDAvailableGuardConditionManager
extends SDAbstractAvailableManager {
    public SDAvailableGuardConditionManager(Shell shell, SDEditDomain domain) {
        super(shell, domain);
    }

    protected void initializeDialog() {
        this.getShell().setText("Available Guard Condition Manager");
    }

    protected void initializeInternalList() {
        this.internalList.setObjects(this.domain.getRootStateMachine().getInternalGuardConditions());
    }

    protected void initializeTemplateList() {
        this.templateList.setObjects(this.domain.getProject().getGuardConditions());
    }

    protected void removePushed(SelectionEvent e) {
        boolean isOK = MessageDialog.openQuestion((Shell)this.getShell(), (String)"\u30ac\u30fc\u30c9\u6761\u4ef6\u306e\u524a\u9664", (String)"\u672c\u5f53\u306b\u524a\u9664\u3057\u3066\u3044\u3044\u3067\u3059\u304b\uff1f");
        if (isOK) {
            Iterator ite = this.internalList.getSelectionObjects().iterator();
            while (ite.hasNext()) {
                SDInternalGuardCondition guard = (SDInternalGuardCondition)ite.next();
                this.domain.getDocument().destroyInternalGuardCondition(guard);
                this.internalList.remove(guard);
            }
        }
    }

    protected void renamePushed(SelectionEvent e) {
        SDInternalGuardCondition guard = (SDInternalGuardCondition)this.internalList.getSelectionObject();
        InputDialog dialog = new InputDialog(this.getShell(), "Change Name", "Input new name.", guard.getName(), (IInputValidator)new SDGuardConditionNameValidator());
        int result = dialog.open();
        if (result == 0) {
            this.domain.getDocument().setNameToInternalGuardCondition(guard, dialog.getValue());
            this.initializeInternalList();
        }
    }

    protected void createPushed(SelectionEvent e) {
        SDCreateGuardConditionDialog dialog = new SDCreateGuardConditionDialog((EditDomain)this.domain);
        int result = dialog.open();
        if (result == 0) {
            SDInternalGuardCondition guard = (SDInternalGuardCondition)dialog.getNewGuardCondition();
            this.internalList.add(guard);
        }
    }
}

