/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.propertyedit;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import sdeditor.editpart.propertyedit.SDTransitionEditDialog;
import sdeditor.model.SDEvent;
import sdeditor.model.SDTransition;

public class SDEditEventGroup {
    private SDTransitionEditDialog parent;
    private Command changeEventCommand = null;
    private Combo eventCombo = null;

    public SDEditEventGroup(SDTransitionEditDialog parent) {
        this.parent = parent;
    }

    public void addEventGroup(Composite parent) {
        Group eventGroup = new Group(parent, 0);
        eventGroup.setLayoutData((Object)new GridData(768));
        eventGroup.setText("Event");
        eventGroup.setLayout(null);
        this.eventCombo = new Combo((Composite)eventGroup, 8);
        this.eventCombo.setLocation(15, 20);
        this.eventCombo.setSize(200, 100);
        this.eventCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDEditEventGroup.this.eventChanged(e);
            }
        });
        this.initializeEventCombo();
    }

    public void initializeEventCombo() {
        ArrayList<SDEvent> events = new ArrayList<SDEvent>();
        events.add(SDTransition.defaultEvent);
        events.addAll(this.parent.getDomain().getProject().getEvents());
        this.eventCombo.removeAll();
        Iterator ite = events.iterator();
        while (ite.hasNext()) {
            SDEvent event = (SDEvent)ite.next();
            this.eventCombo.add(event.getName());
            this.eventCombo.setData(event.getName(), (Object)event);
        }
        int selectionIndex = events.indexOf(this.parent.getTransition().getEvent());
        this.eventCombo.select(selectionIndex);
    }

    private void eventChanged(ModifyEvent e) {
        SDEvent event = (SDEvent)this.eventCombo.getData(this.eventCombo.getText());
        this.changeEventCommand = this.parent.getDomain().SetEventToTransitionCommand(this.parent.getTransition(), event);
    }

    public Command getChangeEventCommand() {
        return this.changeEventCommand;
    }
}

