/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.editpart.propertyedit;

import org.apache.log4j.Logger;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sdeditor.editpart.propertyedit.SDActionListComposite;
import sdeditor.editpart.propertyedit.SDAvaliableActionListComposite;
import sdeditor.editpart.propertyedit.SDEditDialog;
import sdeditor.editpart.propertyedit.SDStateActionListComposite;
import sdeditor.model.SDCompositeState;

public class SDStateEditDialog
extends SDEditDialog {
    private static final Logger logger;
    private SDCompositeState state;
    private Text nameText;
    private SDActionListComposite doActionList;
    private SDActionListComposite entryActionList;
    private SDActionListComposite exitActionList;
    private SDAvaliableActionListComposite availableActionList;
    private String name;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.editpart.propertyedit.SDStateEditDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    public SDStateEditDialog(EditDomain domain, SDCompositeState state) {
        super(domain);
        this.state = state;
        this.name = this.state.getName();
    }

    public SDStateEditDialog(Shell shell, EditDomain domain, SDCompositeState state) {
        super(shell, domain);
        this.state = state;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("State Specification");
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeComposite(composite);
        return composite;
    }

    protected void initializeComposite(Composite composite) {
        composite.setSize(200, 200);
        composite.setLayout((Layout)new GridLayout());
        this.initializeNameGroup(composite);
        this.initializeActionGroup(composite);
        composite.pack();
    }

    private void initializeNameGroup(Composite composite) {
        Group nameGroup = new Group(composite, 0);
        nameGroup.setText("Name");
        nameGroup.setLayoutData((Object)new GridData(768));
        nameGroup.setLayout(null);
        this.nameText = new Text((Composite)nameGroup, 2048);
        this.nameText.setLocation(20, 20);
        this.nameText.setSize(200, 20);
        this.nameText.setText(this.state.getName());
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SDStateEditDialog.this.changeText();
            }
        });
    }

    private void initializeActionGroup(Composite composite) {
        Group actionGroup = new Group(composite, 0);
        actionGroup.setText("Action");
        RowLayout layout = new RowLayout(256);
        layout.pack = false;
        actionGroup.setLayout((Layout)layout);
        Composite cLeft = new Composite((Composite)actionGroup, 0);
        cLeft.setLayout((Layout)new FillLayout(512));
        this.availableActionList = new SDAvaliableActionListComposite((Composite)actionGroup, this.getDomain());
        this.entryActionList = this.initializeEachActionComposite(cLeft, "EntryAction", 1);
        this.doActionList = this.initializeEachActionComposite(cLeft, "DoAction", 2);
        this.exitActionList = this.initializeEachActionComposite(cLeft, "ExitAction", 3);
    }

    private SDActionListComposite initializeEachActionComposite(Composite parent, String labelText, int type) {
        SDStateActionListComposite actionListComposite = new SDStateActionListComposite(parent, 0, this.state, type, super.getDomain());
        actionListComposite.setLabelText(labelText);
        actionListComposite.setAvailableActions(this.availableActionList);
        return actionListComposite;
    }

    protected Command getCommand() {
        CompoundCommand command = new CompoundCommand("state edit");
        if (this.doActionList.getActionCommands().size() != 0) {
            command.add((Command)this.doActionList.getActionCommands());
        }
        if (this.exitActionList.getActionCommands().size() != 0) {
            command.add((Command)this.exitActionList.getActionCommands());
        }
        if (this.entryActionList.getActionCommands().size() != 0) {
            command.add((Command)this.entryActionList.getActionCommands());
        }
        command.add(super.getDomain().SetNameToStateCommand(this.state, this.name));
        return command;
    }

    private void changeText() {
        if (this.nameText.getText().equals("")) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
            this.name = this.nameText.getText();
        }
    }
}

