/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.figure;

import org.apache.log4j.Logger;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import sdeditor.SDEditorException;
import sdeditor.SDPlugin;
import sdeditor.figure.SDHistoryStateFigure;
import sdeditor.figure.SDInitialStateFigure;
import sdeditor.figure.SDStateFigure;
import sdeditor.figure.SDTerminalStateFigure;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDElement;
import sdeditor.model.SDHistoryState;
import sdeditor.model.SDInitialState;
import sdeditor.model.SDRootStateMachine;
import sdeditor.model.SDTerminalState;
import sdeditor.model.SDTransition;
import sdeditor.model.SDTransitionLabel;

public class SDFigureFactory {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.figure.SDFigureFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz.getName());
    }

    /*
     * WARNING - void declaration
     */
    public static IFigure createFigure(SDElement model) {
        void var1_1;
        Object figure;
        logger.debug((Object)("createFigure" + model));
        if (model instanceof SDRootStateMachine) {
            figure = new FreeformLayer();
            figure.setLayoutManager((LayoutManager)new FreeformLayout());
            figure.setBorder((Border)new MarginBorder(5));
            figure.setOpaque(true);
        } else if (model instanceof SDCompositeState) {
            figure = new SDStateFigure();
        } else if (model instanceof SDInitialState) {
            figure = new SDInitialStateFigure();
        } else if (model instanceof SDTerminalState) {
            figure = new SDTerminalStateFigure();
        } else if (model instanceof SDHistoryState) {
            figure = new SDHistoryStateFigure();
        } else if (model instanceof SDTransition) {
            figure = SDFigureFactory.createTransitionFigure();
        } else if (model instanceof SDTransitionLabel) {
            Label label = new Label();
            label.setForegroundColor(SDPlugin.DEFAULT_PEN_COLOR);
            figure = label;
        } else {
            throw new SDEditorException("illegal model for figure");
        }
        return var1_1;
    }

    public static Connection createTransitionFigure() {
        PolylineConnection polyline = new PolylineConnection();
        polyline.setLineWidth(1);
        polyline.setForegroundColor(SDPlugin.DEFAULT_STATE_PEN_COLOR);
        PolylineDecoration arrow = new PolylineDecoration();
        arrow.setScale(10.0, 3.0);
        polyline.setTargetDecoration((RotatableDecoration)arrow);
        return polyline;
    }
}

