/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.figure;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Polyline;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import sdeditor.SDPlugin;
import sdeditor.figure.SDNodeFigure;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;

public class SDStateFigure
extends SDNodeFigure {
    private static final String ENTRY = "entry";
    private static final String DO = "do";
    private static final String EXIT = "exit";
    private static final String ACTION_TEXT_SEPARATOR = " : ";
    private boolean hasAction = false;
    private Figure titleLayer = new Figure();
    private Figure actionLayer = new Figure();
    private Label titleLabel = new Label();
    public static final int xMargin = 10;
    public static final int yMargin = 10;
    private int layoutCurrentHeight = 0;

    public SDStateFigure() {
        this.initialize();
        this.initializeComponents();
    }

    protected void initialize() {
        this.setLayoutManager((LayoutManager)new XYLayout());
        this.setBorder(null);
    }

    protected void initializeComponents() {
        DelegatingLayout titleLayout = new DelegatingLayout();
        this.titleLayer.setLayoutManager((LayoutManager)titleLayout);
        this.titleLayer.setForegroundColor(SDPlugin.DEFAULT_PEN_COLOR);
        FlowLayout actionLayout = new FlowLayout(false);
        actionLayout.setMinorSpacing(0);
        this.actionLayer.setLayoutManager((LayoutManager)actionLayout);
        this.add((IFigure)this.titleLayer);
        this.titleLayer.add((IFigure)this.titleLabel, (Object)new TitleLabelLocator());
        this.titleLayer.add((IFigure)new StateLine(), (Object)new LineLocator());
        this.titleLayer.add((IFigure)this.actionLayer, (Object)new ActionLabelsLocator());
    }

    public void updateVisual(SDCompositeState state) {
        this.titleLabel.setText(state.getName());
        this.actionLayer.removeAll();
        this.hasAction = false;
        this.updateActionTexts(state.getEntryActions(), ENTRY);
        this.updateActionTexts(state.getDoActions(), DO);
        this.updateActionTexts(state.getExitActions(), EXIT);
    }

    private void updateActionTexts(List actions, String category) {
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            String name = ((SDAction)i.next()).getName();
            String text = String.valueOf(category) + ACTION_TEXT_SEPARATOR + name;
            this.actionLayer.add((IFigure)new Label(text));
            this.hasAction = true;
        }
    }

    public Label getTitleLabel() {
        return this.titleLabel;
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.titleLayer.setBounds(r);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (index == -1) {
            super.add(figure, constraint, index);
        } else if (figure == this.titleLayer) {
            super.add(figure, constraint, 0);
        } else {
            super.add(figure, constraint, index + 1);
        }
    }

    protected void paintFigure(Graphics g) {
        super.paintFigure(g);
        g.setForegroundColor(SDPlugin.DEFAULT_STATE_PEN_COLOR);
        g.setBackgroundColor(SDPlugin.DEFAULT_STATE_FILL_COLOR);
        g.setLineWidth(1);
        Rectangle r = super.getBounds();
        g.fillRoundRectangle(r, 20, 20);
        g.drawRoundRectangle(r, 20, 20);
    }

    private int layoutGetWidth() {
        Rectangle r = this.getBounds();
        return r.width;
    }

    private int layoutGetHeight() {
        Rectangle r = this.getBounds();
        return r.height;
    }

    private Point layoutGetLocation() {
        Rectangle r = this.getBounds();
        int x = r.x + 10;
        int y = r.y + this.layoutCurrentHeight;
        return new Point(x, y);
    }

    class TitleLabelLocator
    implements Locator {
        TitleLabelLocator() {
        }

        public void relocate(IFigure target) {
            SDStateFigure.this.layoutCurrentHeight = 10;
            int width = SDStateFigure.this.layoutGetWidth() - 20;
            int height = target.getPreferredSize().height;
            target.setBounds(new Rectangle(SDStateFigure.this.layoutGetLocation(), new Dimension(width, height)));
            SDStateFigure sDStateFigure = SDStateFigure.this;
            sDStateFigure.layoutCurrentHeight = sDStateFigure.layoutCurrentHeight + height;
        }
    }

    class LineLocator
    implements Locator {
        LineLocator() {
        }

        public void relocate(IFigure target) {
            int width = SDStateFigure.this.layoutGetWidth() - 20;
            int height = 20;
            target.setBounds(new Rectangle(SDStateFigure.this.layoutGetLocation(), new Dimension(width, height)));
            SDStateFigure sDStateFigure = SDStateFigure.this;
            sDStateFigure.layoutCurrentHeight = sDStateFigure.layoutCurrentHeight + height;
        }
    }

    class ActionLabelsLocator
    implements Locator {
        ActionLabelsLocator() {
        }

        public void relocate(IFigure target) {
            int width = SDStateFigure.this.layoutGetWidth() - 20;
            int height = SDStateFigure.this.layoutGetHeight() - SDStateFigure.this.layoutCurrentHeight;
            target.setBounds(new Rectangle(SDStateFigure.this.layoutGetLocation(), new Dimension(width, height)));
        }
    }

    class StateLine
    extends Figure {
        StateLine() {
        }

        protected void paintFigure(Graphics g) {
            super.paintFigure(g);
            if (SDStateFigure.this.hasAction) {
                Polyline line = new Polyline();
                line.setForegroundColor(SDPlugin.DEFAULT_STATE_PEN_COLOR);
                line.setLineWidth(1);
                Rectangle r = super.getBounds();
                int y = r.getCenter().y;
                int left = r.getLeft().x;
                int right = r.getRight().x;
                line.setStart(new Point(left, y));
                line.setEnd(new Point(right, y));
                line.paint(g);
            }
        }
    }
}

