/*
 * Decompiled with CFR 0.152.
 */
package sdeditor.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.draw2d.geometry.Rectangle;
import sdeditor.model.SDAction;
import sdeditor.model.SDCompositeState;
import sdeditor.model.SDEvent;
import sdeditor.model.SDGuardCondition;
import sdeditor.model.SDHistoryState;
import sdeditor.model.SDInitialState;
import sdeditor.model.SDInternalAction;
import sdeditor.model.SDInternalEvent;
import sdeditor.model.SDInternalGuardCondition;
import sdeditor.model.SDRelativePoint;
import sdeditor.model.SDRootStateMachine;
import sdeditor.model.SDSelfTransition;
import sdeditor.model.SDState;
import sdeditor.model.SDStateMachine;
import sdeditor.model.SDTerminalState;
import sdeditor.model.SDTransition;
import sdeditor.model.SDTransitionLabel;

public class SDDocument {
    private static final Logger logger;
    public static final int ENTRY = 1;
    public static final int DO = 2;
    public static final int EXIT = 3;
    public static final int UP = -1;
    public static final int DOWN = 1;
    private SDRootStateMachine rootStateMachine = new SDRootStateMachine();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("sdeditor.model.SDDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("sdeditor.model.SDDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((String)clazz2.getName());
    }

    public SDRootStateMachine getRootStateMachine() {
        return this.rootStateMachine;
    }

    public void addStateToStateMachine(SDStateMachine parent, SDState state) {
        if (state instanceof SDInitialState) {
            parent.setInitialState((SDInitialState)state);
        } else if (state instanceof SDTerminalState) {
            parent.addTerminalState((SDTerminalState)state);
        } else if (state instanceof SDHistoryState) {
            parent.setHistoryState((SDHistoryState)state);
        } else {
            parent.addState(state);
        }
    }

    public void addStateToStateMachine(SDStateMachine parent, SDState state, List transitions) {
        this.addStateToStateMachine(parent, state);
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            SDTransition transition = (SDTransition)i.next();
            this.addTransition(transition);
        }
    }

    public void removeOrphanStateFromStateMachine(SDStateMachine parent, SDState state) {
        logger.debug((Object)(parent + "," + state.getName()));
        if (state instanceof SDInitialState) {
            parent.setInitialState(null);
        } else if (state instanceof SDTerminalState) {
            parent.removeTerminalState((SDTerminalState)state);
        } else if (state instanceof SDHistoryState) {
            parent.setHistoryState(null);
        } else {
            parent.removeState(state);
        }
    }

    public List removeStateFromStateMachine(SDStateMachine parent, SDState state) {
        logger.debug((Object)(parent + "," + state.getName()));
        Set transitions = this.getAllTransitions(state);
        transitions.addAll(state.getTargetTransitions());
        transitions.addAll(state.getSourceTransitions());
        Iterator i = transitions.iterator();
        while (i.hasNext()) {
            SDTransition transition = (SDTransition)i.next();
            this.removeTransition(transition);
        }
        this.removeOrphanStateFromStateMachine(parent, state);
        return new ArrayList(transitions);
    }

    private Set getAllTransitions(SDState state) {
        HashSet transitions = new HashSet();
        SDState current = state;
        transitions.addAll(state.getTargetTransitions());
        transitions.addAll(state.getSourceTransitions());
        if (current instanceof SDCompositeState) {
            Iterator i = ((SDCompositeState)current).getAllStates().iterator();
            while (i.hasNext()) {
                SDState child = (SDState)i.next();
                transitions.addAll(this.getAllTransitions(child));
            }
        }
        return transitions;
    }

    public void setBoundsToState(SDState state, Rectangle r) {
        state.setBounds(r);
    }

    public void setNameToState(SDCompositeState state, String name) {
        state.setName(name);
    }

    public void addActionToState(SDState state, int where, SDAction action) {
        int index = this.getActionsFromState(state, where).size();
        this.addActionToState(state, where, action, index);
    }

    public void addActionToState(SDState state, int where, SDAction action, int index) {
        switch (where) {
            case 1: {
                state.addEntryAction(action, index);
                break;
            }
            case 2: {
                state.addDoAction(action, index);
                break;
            }
            case 3: {
                state.addExitAction(action, index);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal argument in where");
            }
        }
    }

    public void removeActionFromState(SDState state, int where, int index) {
        switch (where) {
            case 1: {
                state.removeEntryAction(index);
                break;
            }
            case 2: {
                state.removeDoAction(index);
                break;
            }
            case 3: {
                state.removeExitAction(index);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal argument in where");
            }
        }
    }

    public void moveActionInState(SDState state, int where, int index, int move) {
        switch (where) {
            case 1: {
                state.moveEntryAction(index, move);
                break;
            }
            case 2: {
                state.moveDoAction(index, move);
                break;
            }
            case 3: {
                state.moveExitAction(index, move);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal argument in where");
            }
        }
    }

    public List getActionsFromState(SDState state, int where) {
        switch (where) {
            case 1: {
                return state.getEntryActions();
            }
            case 2: {
                return state.getDoActions();
            }
            case 3: {
                return state.getExitActions();
            }
        }
        throw new IllegalArgumentException("illegal argument in where");
    }

    public SDTransition createTransition(SDState source, SDState target) {
        SDTransition transition = new SDTransition();
        this.setStateToTransition(transition, source, target);
        this.addTransition(transition);
        return transition;
    }

    public void setStateToTransition(SDTransition transition, SDState source, SDState target) {
        transition.setSourceState(source);
        transition.setTargetState(target);
        if (transition instanceof SDSelfTransition) {
            ((SDSelfTransition)transition).refreshBendpoints();
        }
    }

    public void addTransition(SDTransition transition) {
        logger.debug((Object)transition);
        if (!$assertionsDisabled && transition.getSourceState() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && transition.getTargetState() == null) {
            throw new AssertionError();
        }
        if (!transition.getSourceState().getSourceTransitions().contains(transition)) {
            transition.getSourceState().addSourceTransition(transition);
        }
        if (!transition.getTargetState().getTargetTransitions().contains(transition)) {
            transition.getTargetState().addTargetTransition(transition);
        }
    }

    public void removeTransition(SDTransition transition) {
        logger.debug((Object)transition);
        if (transition.getSourceState().getSourceTransitions().contains(transition)) {
            transition.getSourceState().removeSourceTransition(transition);
        }
        if (transition.getTargetState().getTargetTransitions().contains(transition)) {
            transition.getTargetState().removeTargetTransition(transition);
        }
    }

    public void reconnectTransition(SDTransition transition, SDState source, SDState target) {
        if (source != null) {
            transition.getSourceState().removeSourceTransition(transition);
            transition.setSourceState(source);
            source.addSourceTransition(transition);
        }
        if (target != null) {
            transition.getTargetState().removeTargetTransition(transition);
            transition.setTargetState(target);
            target.addTargetTransition(transition);
        }
    }

    public void setEventToTransition(SDTransition transition, SDEvent event) {
        transition.setEvent(event);
    }

    public void setGuardConditionToTransition(SDTransition transition, SDGuardCondition guardCondition) {
        transition.setGuardCondition(guardCondition);
    }

    public void addActionToTransition(SDTransition transition, SDAction action) {
        int index = transition.getActions().size();
        this.addActionToTransition(transition, action, index);
    }

    public void addActionToTransition(SDTransition transition, SDAction action, int index) {
        transition.addAction(action, index);
    }

    public SDAction removeActionFromTransition(SDTransition transition, int index) {
        return transition.removeAction(index);
    }

    public void moveActionInTransition(SDTransition transition, int index, int move) {
        transition.moveAction(index, move);
    }

    public void addBendpointToTransition(SDTransition transition, SDRelativePoint point, int index) {
        transition.addBendpoint(point, index);
    }

    public SDRelativePoint removeBendpointFromTransition(SDTransition transition, int index) {
        return transition.removeBendpoint(index);
    }

    public void moveBendpointInTransition(SDTransition transition, int index, SDRelativePoint bendpoint) {
        transition.moveBendpoint(index, bendpoint);
    }

    public void setLocationToTransitionLabel(SDTransitionLabel label, SDRelativePoint point) {
        label.setLocation(point);
    }

    public SDInternalEvent createInternalEvent(String name) {
        SDInternalEvent event = new SDInternalEvent(name);
        this.getRootStateMachine().addInternalEvent(event);
        return event;
    }

    public SDInternalGuardCondition createInternalGuardCondition(String name) {
        SDInternalGuardCondition guard = new SDInternalGuardCondition(name);
        this.getRootStateMachine().addInternalGuardCondition(guard);
        return guard;
    }

    public void destroyInternalGuardCondition(SDInternalGuardCondition guard) {
        this.getRootStateMachine().removeInternalGuardCondition(guard);
    }

    public void setNameToInternalGuardCondition(SDInternalGuardCondition guard, String name) {
        guard.setName(name);
    }

    public SDInternalAction createInternalAction(String name) {
        SDInternalAction action = new SDInternalAction(name);
        this.getRootStateMachine().addInternalAction(action);
        return action;
    }

    public void destroyInternalAction(SDInternalAction action) {
        this.getRootStateMachine().removeInternalAction(action);
    }

    public void setNameToInternalAction(SDInternalAction action, String name) {
        action.setName(name);
    }
}

